/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.util;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import org.asamk.signal.manager.api.InvalidNumberException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoneNumberFormatter {
    private static final Logger logger = LoggerFactory.getLogger(PhoneNumberFormatter.class);

    private static String impreciseFormatNumber(String number, String localNumber) {
        if ((number = number.replaceAll("[^0-9+]", "")).charAt(0) == '+') {
            return number;
        }
        if (localNumber.charAt(0) == '+') {
            localNumber = localNumber.substring(1);
        }
        if (localNumber.length() == number.length() || number.length() > localNumber.length()) {
            return "+" + number;
        }
        int difference = localNumber.length() - number.length();
        return "+" + localNumber.substring(0, difference) + number;
    }

    public static String formatNumber(String number, String localNumber) throws InvalidNumberException {
        if (number == null) {
            throw new InvalidNumberException("Null String passed as number.");
        }
        if (number.contains("@")) {
            throw new InvalidNumberException("Possible attempt to use email address.");
        }
        if ((number = number.replaceAll("[^0-9+]", "")).isEmpty()) {
            throw new InvalidNumberException("No valid characters found.");
        }
        try {
            PhoneNumberUtil util = PhoneNumberUtil.getInstance();
            Phonenumber.PhoneNumber localNumberObject = util.parse((CharSequence)localNumber, null);
            String localCountryCode = util.getRegionCodeForNumber(localNumberObject);
            logger.trace("Got local CC: {}", (Object)localCountryCode);
            Phonenumber.PhoneNumber numberObject = util.parse((CharSequence)number, localCountryCode);
            return util.format(numberObject, PhoneNumberUtil.PhoneNumberFormat.E164);
        }
        catch (NumberParseException e) {
            logger.debug("{}: {}", (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)e.getMessage());
            return PhoneNumberFormatter.impreciseFormatNumber(number, localNumber);
        }
    }
}

