/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.prekeys;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.asamk.signal.manager.storage.prekeys.PreKeyStore;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.state.PreKeyRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyPreKeyStore {
    private static final Logger logger = LoggerFactory.getLogger(LegacyPreKeyStore.class);
    static final Pattern preKeyFileNamePattern = Pattern.compile("(\\d+)");

    public static void migrate(File preKeysPath, PreKeyStore preKeyStore) {
        File[] files = preKeysPath.listFiles();
        if (files == null) {
            return;
        }
        List<PreKeyRecord> preKeyRecords = Arrays.stream(files).filter(f -> preKeyFileNamePattern.matcher(f.getName()).matches()).map(LegacyPreKeyStore::loadPreKeyRecord).toList();
        preKeyStore.addLegacyPreKeys(preKeyRecords);
        LegacyPreKeyStore.removeAllPreKeys(preKeysPath);
    }

    private static void removeAllPreKeys(File preKeysPath) {
        File[] files = preKeysPath.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                logger.error("Failed to delete pre key file {}: {}", (Object)file, (Object)e.getMessage());
            }
        }
        try {
            Files.delete(preKeysPath.toPath());
        }
        catch (IOException e) {
            logger.error("Failed to delete pre key directory {}: {}", (Object)preKeysPath, (Object)e.getMessage());
        }
    }

    private static PreKeyRecord loadPreKeyRecord(File file) {
        PreKeyRecord preKeyRecord;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            preKeyRecord = new PreKeyRecord(inputStream.readAllBytes());
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InvalidMessageException e) {
                logger.error("Failed to load pre key: {}", (Object)e.getMessage());
                throw new AssertionError((Object)e);
            }
        }
        inputStream.close();
        return preKeyRecord;
    }
}

