/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages;

import io.reactivex.rxjava3.annotations.NonNull;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.whispersystems.signalservice.api.util.Preconditions;
import org.whispersystems.signalservice.internal.push.GroupContextV2;

public final class SignalServiceGroupV2 {
    private final GroupMasterKey masterKey;
    private final int revision;
    private final byte[] signedGroupChange;

    private SignalServiceGroupV2(Builder builder) {
        this.masterKey = builder.masterKey;
        this.revision = builder.revision;
        this.signedGroupChange = builder.signedGroupChange != null ? (byte[])builder.signedGroupChange.clone() : null;
    }

    public static SignalServiceGroupV2 fromProtobuf(@NonNull GroupContextV2 groupContextV2) {
        GroupMasterKey masterKey;
        Preconditions.checkArgument(groupContextV2.masterKey != null && groupContextV2.revision != null);
        try {
            masterKey = new GroupMasterKey(groupContextV2.masterKey.toByteArray());
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
        Builder builder = SignalServiceGroupV2.newBuilder(masterKey);
        if (groupContextV2.groupChange != null && groupContextV2.groupChange.size() > 0) {
            builder.withSignedGroupChange(groupContextV2.groupChange.toByteArray());
        }
        return builder.withRevision(groupContextV2.revision).build();
    }

    public GroupMasterKey getMasterKey() {
        return this.masterKey;
    }

    public int getRevision() {
        return this.revision;
    }

    public byte[] getSignedGroupChange() {
        return this.signedGroupChange;
    }

    public boolean hasSignedGroupChange() {
        return this.signedGroupChange != null && this.signedGroupChange.length > 0;
    }

    public static Builder newBuilder(GroupMasterKey masterKey) {
        return new Builder(masterKey);
    }

    public static class Builder {
        private final GroupMasterKey masterKey;
        private int revision;
        private byte[] signedGroupChange;

        private Builder(GroupMasterKey masterKey) {
            if (masterKey == null) {
                throw new IllegalArgumentException();
            }
            this.masterKey = masterKey;
        }

        public Builder withRevision(int revision) {
            this.revision = revision;
            return this;
        }

        public Builder withSignedGroupChange(byte[] signedGroupChange) {
            this.signedGroupChange = signedGroupChange;
            return this;
        }

        public SignalServiceGroupV2 build() {
            return new SignalServiceGroupV2(this);
        }
    }
}

