//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfdateformatterkey?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "CFBase")]
pub type CFDateFormatterKey = CFString;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfdateformatter?language=objc)
#[repr(C)]
pub struct CFDateFormatter {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFDateFormatter"]
    unsafe impl CFDateFormatter {}
);

#[cfg(all(feature = "CFBase", feature = "CFLocale"))]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterCreateDateFormatFromTemplate(
    allocator: Option<&CFAllocator>,
    tmplate: Option<&CFString>,
    options: CFOptionFlags,
    locale: Option<&CFLocale>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFDateFormatterCreateDateFormatFromTemplate(
            allocator: Option<&CFAllocator>,
            tmplate: Option<&CFString>,
            options: CFOptionFlags,
            locale: Option<&CFLocale>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret =
        unsafe { CFDateFormatterCreateDateFormatFromTemplate(allocator, tmplate, options, locale) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFDateFormatter {
    #[doc(alias = "CFDateFormatterGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFDateFormatterGetTypeID() -> CFTypeID;
        }
        unsafe { CFDateFormatterGetTypeID() }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfdateformatterstyle?language=objc)
// NS_ENUM
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFDateFormatterStyle(pub CFIndex);
#[cfg(feature = "CFBase")]
impl CFDateFormatterStyle {
    #[doc(alias = "kCFDateFormatterNoStyle")]
    pub const NoStyle: Self = Self(0);
    #[doc(alias = "kCFDateFormatterShortStyle")]
    pub const ShortStyle: Self = Self(1);
    #[doc(alias = "kCFDateFormatterMediumStyle")]
    pub const MediumStyle: Self = Self(2);
    #[doc(alias = "kCFDateFormatterLongStyle")]
    pub const LongStyle: Self = Self(3);
    #[doc(alias = "kCFDateFormatterFullStyle")]
    pub const FullStyle: Self = Self(4);
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFDateFormatterStyle {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFDateFormatterStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfiso8601dateformatoptions?language=objc)
// NS_OPTIONS
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFISO8601DateFormatOptions(pub CFOptionFlags);
#[cfg(feature = "CFBase")]
bitflags::bitflags! {
    impl CFISO8601DateFormatOptions: CFOptionFlags {
        #[doc(alias = "kCFISO8601DateFormatWithYear")]
        const WithYear = 1<<0;
        #[doc(alias = "kCFISO8601DateFormatWithMonth")]
        const WithMonth = 1<<1;
        #[doc(alias = "kCFISO8601DateFormatWithWeekOfYear")]
        const WithWeekOfYear = 1<<2;
        #[doc(alias = "kCFISO8601DateFormatWithDay")]
        const WithDay = 1<<4;
        #[doc(alias = "kCFISO8601DateFormatWithTime")]
        const WithTime = 1<<5;
        #[doc(alias = "kCFISO8601DateFormatWithTimeZone")]
        const WithTimeZone = 1<<6;
        #[doc(alias = "kCFISO8601DateFormatWithSpaceBetweenDateAndTime")]
        const WithSpaceBetweenDateAndTime = 1<<7;
        #[doc(alias = "kCFISO8601DateFormatWithDashSeparatorInDate")]
        const WithDashSeparatorInDate = 1<<8;
        #[doc(alias = "kCFISO8601DateFormatWithColonSeparatorInTime")]
        const WithColonSeparatorInTime = 1<<9;
        #[doc(alias = "kCFISO8601DateFormatWithColonSeparatorInTimeZone")]
        const WithColonSeparatorInTimeZone = 1<<10;
        #[doc(alias = "kCFISO8601DateFormatWithFractionalSeconds")]
        const WithFractionalSeconds = 1<<11;
        #[doc(alias = "kCFISO8601DateFormatWithFullDate")]
        const WithFullDate = CFISO8601DateFormatOptions::WithYear.0|CFISO8601DateFormatOptions::WithMonth.0|CFISO8601DateFormatOptions::WithDay.0|CFISO8601DateFormatOptions::WithDashSeparatorInDate.0;
        #[doc(alias = "kCFISO8601DateFormatWithFullTime")]
        const WithFullTime = CFISO8601DateFormatOptions::WithTime.0|CFISO8601DateFormatOptions::WithColonSeparatorInTime.0|CFISO8601DateFormatOptions::WithTimeZone.0|CFISO8601DateFormatOptions::WithColonSeparatorInTimeZone.0;
        #[doc(alias = "kCFISO8601DateFormatWithInternetDateTime")]
        const WithInternetDateTime = CFISO8601DateFormatOptions::WithFullDate.0|CFISO8601DateFormatOptions::WithFullTime.0;
    }
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFISO8601DateFormatOptions {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFISO8601DateFormatOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterCreateISO8601Formatter(
    allocator: Option<&CFAllocator>,
    format_options: CFISO8601DateFormatOptions,
) -> Option<CFRetained<CFDateFormatter>> {
    extern "C-unwind" {
        fn CFDateFormatterCreateISO8601Formatter(
            allocator: Option<&CFAllocator>,
            format_options: CFISO8601DateFormatOptions,
        ) -> Option<NonNull<CFDateFormatter>>;
    }
    let ret = unsafe { CFDateFormatterCreateISO8601Formatter(allocator, format_options) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFLocale"))]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterCreate(
    allocator: Option<&CFAllocator>,
    locale: Option<&CFLocale>,
    date_style: CFDateFormatterStyle,
    time_style: CFDateFormatterStyle,
) -> Option<CFRetained<CFDateFormatter>> {
    extern "C-unwind" {
        fn CFDateFormatterCreate(
            allocator: Option<&CFAllocator>,
            locale: Option<&CFLocale>,
            date_style: CFDateFormatterStyle,
            time_style: CFDateFormatterStyle,
        ) -> Option<NonNull<CFDateFormatter>>;
    }
    let ret = unsafe { CFDateFormatterCreate(allocator, locale, date_style, time_style) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFLocale")]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterGetLocale(
    formatter: &CFDateFormatter,
) -> Option<CFRetained<CFLocale>> {
    extern "C-unwind" {
        fn CFDateFormatterGetLocale(formatter: &CFDateFormatter) -> Option<NonNull<CFLocale>>;
    }
    let ret = unsafe { CFDateFormatterGetLocale(formatter) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFDateFormatterGetDateStyle(formatter: &CFDateFormatter) -> CFDateFormatterStyle;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFDateFormatterGetTimeStyle(formatter: &CFDateFormatter) -> CFDateFormatterStyle;
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterGetFormat(
    formatter: &CFDateFormatter,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFDateFormatterGetFormat(formatter: &CFDateFormatter) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFDateFormatterGetFormat(formatter) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFDateFormatterSetFormat(formatter: &CFDateFormatter, format_string: Option<&CFString>);
}

#[cfg(all(feature = "CFBase", feature = "CFDate"))]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterCreateStringWithDate(
    allocator: Option<&CFAllocator>,
    formatter: Option<&CFDateFormatter>,
    date: Option<&CFDate>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFDateFormatterCreateStringWithDate(
            allocator: Option<&CFAllocator>,
            formatter: Option<&CFDateFormatter>,
            date: Option<&CFDate>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFDateFormatterCreateStringWithDate(allocator, formatter, date) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFDate"))]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterCreateStringWithAbsoluteTime(
    allocator: Option<&CFAllocator>,
    formatter: Option<&CFDateFormatter>,
    at: CFAbsoluteTime,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFDateFormatterCreateStringWithAbsoluteTime(
            allocator: Option<&CFAllocator>,
            formatter: Option<&CFDateFormatter>,
            at: CFAbsoluteTime,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFDateFormatterCreateStringWithAbsoluteTime(allocator, formatter, at) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFDate"))]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterCreateDateFromString(
    allocator: Option<&CFAllocator>,
    formatter: Option<&CFDateFormatter>,
    string: Option<&CFString>,
    rangep: *mut CFRange,
) -> Option<CFRetained<CFDate>> {
    extern "C-unwind" {
        fn CFDateFormatterCreateDateFromString(
            allocator: Option<&CFAllocator>,
            formatter: Option<&CFDateFormatter>,
            string: Option<&CFString>,
            rangep: *mut CFRange,
        ) -> Option<NonNull<CFDate>>;
    }
    let ret = unsafe { CFDateFormatterCreateDateFromString(allocator, formatter, string, rangep) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFDate"))]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterGetAbsoluteTimeFromString(
    formatter: &CFDateFormatter,
    string: Option<&CFString>,
    rangep: *mut CFRange,
    atp: *mut CFAbsoluteTime,
) -> bool {
    extern "C-unwind" {
        fn CFDateFormatterGetAbsoluteTimeFromString(
            formatter: &CFDateFormatter,
            string: Option<&CFString>,
            rangep: *mut CFRange,
            atp: *mut CFAbsoluteTime,
        ) -> Boolean;
    }
    let ret = unsafe { CFDateFormatterGetAbsoluteTimeFromString(formatter, string, rangep, atp) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFDateFormatterSetProperty(
        formatter: &CFDateFormatter,
        key: Option<&CFString>,
        value: Option<&CFType>,
    );
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterCopyProperty(
    formatter: &CFDateFormatter,
    key: Option<&CFDateFormatterKey>,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CFDateFormatterCopyProperty(
            formatter: &CFDateFormatter,
            key: Option<&CFDateFormatterKey>,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CFDateFormatterCopyProperty(formatter, key) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterislenient?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterIsLenient: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattertimezone?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterTimeZone: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattercalendarname?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterCalendarName: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterdefaultformat?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterDefaultFormat: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattertwodigitstartdate?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterTwoDigitStartDate: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterdefaultdate?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterDefaultDate: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattercalendar?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterCalendar: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattererasymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterEraSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattermonthsymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterMonthSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattershortmonthsymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterShortMonthSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterweekdaysymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterWeekdaySymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattershortweekdaysymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterShortWeekdaySymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatteramsymbol?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterAMSymbol: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterpmsymbol?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterPMSymbol: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterlongerasymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterLongEraSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterveryshortmonthsymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterVeryShortMonthSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterstandalonemonthsymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterStandaloneMonthSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattershortstandalonemonthsymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterShortStandaloneMonthSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterveryshortstandalonemonthsymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterVeryShortStandaloneMonthSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterveryshortweekdaysymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterVeryShortWeekdaySymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterstandaloneweekdaysymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterStandaloneWeekdaySymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattershortstandaloneweekdaysymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterShortStandaloneWeekdaySymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterveryshortstandaloneweekdaysymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterVeryShortStandaloneWeekdaySymbols:
        Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterquartersymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterQuarterSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattershortquartersymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterShortQuarterSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterstandalonequartersymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterStandaloneQuarterSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattershortstandalonequartersymbols?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterShortStandaloneQuarterSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattergregorianstartdate?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterGregorianStartDate: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterdoesrelativedateformattingkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFDateFormatterDoesRelativeDateFormattingKey: Option<&'static CFDateFormatterKey>;
}
