Example of code that triggers a warning:

```ada
procedure P with
  No_Return,
  Always_Terminates;
```

This warning is issued on procedures which can neither return normally nor
raise an exception, but are annotated with an `Always_Terminates => True`
aspect.

The `Always_Terminate` aspect can be used to provide a condition under which
the procedure necessarily terminates ie. it returns normally or propagates an
exception. `Always_Terminate => True` means that the procedure terminates on
all its valid inputs. Exceptions which might be propagated by a procedure
have to be listed in an `Exceptional_Cases` aspect. If no such aspect is
provided, then the procedure is not allowed to propagate any Ada exception.
A procedure marked `No_Return` which is not allowed to propagate exceptions can
never terminate. Hence there is a contradiction here.
The fix likely consists in either removing the `Always_Terminate => True` or
adding an `Exception_Cases` aspect to specify cases in which the procedure may
raise an exception.

Note that a procedure might fail to terminate for several reasons. It might
loop forever, or exit the program using `OS_Exit`, or propagate an exception in
another language if the binding terminates the program abruptly in this case.
