// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef enums_h
#define enums_h




#include "SDL.h"    // for SDL_Rect




namespace FS
{

enum LogColor
{
    L_RED,
    L_YELLOW,
    L_BLUE,
    L_ORANGE,
    L_GREEN,
    L_PURPLE,
    L_BROWN,
    L_BACKGROUND
}; // enum LogColor
/*
enum CrystalColor
{   
    C_NONE = -1,
    C_RED,
    C_YELLOW,
    C_BLUE,
    C_WHITE
}; // enum CrystalColor
*/
enum BonusType
{
    B_NONE = -1,
    B_DOUBLE_JUMP,
    B_LOGS_TO_BROWN,
    B_CHANGE_DIRECTION,
    B_SLOW_DOWN,
    B_SPEED_UP
}; // enum BonusType
/*    
struct Cell
{
    LogColor lc;
    CrystalColor cc;
    BonusType bt;
}; // struct Cell
*/
enum Direction
{
    LEFT_TO_RIGHT,
    RIGHT_TO_LEFT
}; // enum Direction

// These relate to Albert:
enum Orientation
{
    NORTH, EAST, SOUTH, WEST
}; // enum Orientation

enum KeyboardEvent
{
    UP_KEY_PRESSED,
    RIGHT_KEY_PRESSED,
    DOWN_KEY_PRESSED,
    LEFT_KEY_PRESSED,
    JUMP_KEY_PRESSED,
    ESCAPE_PRESSED,
    PAUSE_KEY_PRESSED,
    UP_KEY_RELEASED,
    RIGHT_KEY_RELEASED,
    DOWN_KEY_RELEASED,
    LEFT_KEY_RELEASED,
    NONE
}; // enum KeyboardEvent
        
enum TurnType
{
    CLOCKWISE, ANTI_CLOCKWISE
}; // enum TurnType
    
enum Strip
{
    WALKING_NORTH,
    WALKING_EAST,
    WALKING_SOUTH,
    WALKING_WEST,
    JUMPING_NORTH,
    JUMPING_EAST,
    JUMPING_SOUTH,
    JUMPING_WEST
}; // enum Strip
 
enum RowDescription
{
    ROW_NONE = -1,
    ROW_0,
    ROW_1,
    ROW_2,
    ROW_3,
    ROW_4,
    ROW_5,
    UPPER_BANK,
    LOWER_BANK,
}; // RowDescription

const int IMAGE_ID_LOG_OFFSET = 1;
const int IMAGE_ID_CRYSTAL_OFFSET = 8;
const int IMAGE_ID_BONUS_OFFSET = 27;
const int NUM_IMAGES = 36;
enum ImageIDs
{
    BACKGROUND,
    LOG_RED,
    LOG_YELLOW,
    LOG_BLUE,
    LOG_ORANGE,
    LOG_GREEN,
    LOG_PURPLE,
    LOG_BROWN,
    CRYSTAL_RED,
    CRYSTAL_YELLOW,
    CRYSTAL_BLUE,
    CRYSTAL_WHITE,
    WALKING_N,
    WALKING_E,
    WALKING_S,
    WALKING_W,
    JUMPING_N,
    JUMPING_E,
    JUMPING_S,
    JUMPING_W,
    SPLASHING_N,
    SPLASHING_E,
    SPLASHING_S,
    SPLASHING_W,
    ZAPPING_NESW,
    FISH,
    WALKING_E_WITH_FISH,
    SPRING,
    LEAF,
    ARROWS,
    SNAIL,
    LIGHTNING,
    STARS,
    PLATE,
    PAUSE_MENU_CONTINUE,
    PAUSE_MENU_QUIT
}; // enum ImageIDs
    
// This array is used in conjunction with the ImageIDs enum to
// determine which layer a sprite/image should be drawn to.
// First value (for BACKGROUND) is never used - it's just there
// to keep the other values in sync.
const int IMAGE_LAYERS[] = { 
        0,  // dummy value for BACKGROUND 
        0,  // LOG_RED
        0,  // LOG_YELLOW
        0,  // LOG_BLUE
        0,  // LOG_ORANGE 
        0,  // LOG_GREEN
        0,  // LOG_PURPLE
        0,  // LOG_BROWN
        1,  // CRYSTAL_RED
        1,  // CRYSTAL_YELLOW
        1,  // CRYSTAL_BLUE
        1,  // CRYSTAL_WHITE
        3,  // WALKING_N
        3,  // WALKING_E
        3,  // WALKING_S
        3,  // WALKING_W
        3,  // JUMPING_N
        3,  // JUMPING_E
        3,  // JUMPING_S
        3,  // JUMPING_W
        3,  // SPLASHING_N
        3,  // SPLASHING_E
        3,  // SPLASHING_S
        3,  // SPLASHING_W
        3,  // ZAPPING_NESW
        0,  // FISH
        3,  // WALKING_E_WITH_FISHNUMS_H

        1,  // SPRING
        1,  // LEAF
        1,  // ARROWS
        1,  // SNAIL
        1,  // LIGHTNING
        2,  // STARS
        0,  // PLATE
        4,  // PAUSE_MENU_CONTINUE
        4   // PAUSE_MENU_QUIT
}; // IMAGE_LAYERS[]

enum PlayReport
{
    PR_OK, 
    PR_LEVEL_COMPLETED, 
    PR_GAME_OVER
}; // enum PlayReport
    
enum Mode { MODE_GAME, MODE_DEMO, MODE_TUTORIAL };

enum PauseType { PAUSE_NONE, PAUSE_USER, PAUSE_AUTO };

} // namespace FS

    

    
#endif

        
