// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Scroller.h"




// *******************
// *** CONSTRUCTOR ***
// *******************
FS::Scroller::Scroller()
{
    // NYI...

} // FS::Scroller::Scroller()

// ******************
// *** DESTRUCTOR ***
// ******************
FS::Scroller::~Scroller()
{
    // NYI...

} // FS::Scroller::~Scroller()




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

void FS::Scroller::change_direction(int row)
{
    if ( my_data.current_directions[row] == LEFT_TO_RIGHT )
    {
        my_data.current_directions[row] = RIGHT_TO_LEFT;
    }
    else
    {
        my_data.current_directions[row] = LEFT_TO_RIGHT;
    } // if ... else
    
} // FS::Scroller::change_direction

// **************************************************

void FS::Scroller::restore_original_directions_and_velocities()
{
    for (int i = 0; i < NUM_ROWS; ++i)
    {
        my_data.current_directions[i] = my_data.original_directions[i];
        my_data.current_velocities[i] = my_data.original_velocities[i];
    } // for
    
} // FS::Scroller::restore_original_directions_and_velocities

// **************************************************

void FS::Scroller::load_data(std::ifstream& fin)
{
    reset_cells();
    
    // 1 row at a time: direction, velocity, row length, data.
    // Store data in 2D array (my_cells) - it's needed
    // by SpriteManager to initialize scrolling sprites.
    
    std::string my_line;
    for (int row = 0; row < NUM_ROWS; ++row)
    {
        int len;    // use this to control inner for loop
        
        // direction
        getline(fin, my_line); 
        my_data.original_directions[row] = my_data.current_directions[row] = 
                (Direction) atoi( my_line.c_str() );
        
        // velocity
        getline(fin, my_line);
        my_data.original_velocities[row] = my_data.current_velocities[row] = 
                (float) atof( my_line.c_str() );
        
        // row length 
        getline(fin, my_line);
        len = my_data.row_lengths_in_cells[row] = atoi( my_line.c_str() );
        my_data.row_lengths_in_pixels[row] = len * CELL_WIDTH;
        
        for (int col = 0; col < len; ++col)   
        {
            getline(fin, my_line);
            
            // log
            my_cells[row][col].lc = (LogColor) atoi( my_line.c_str() );
            my_line.erase( 0, my_line.find(',') + 1 );
            
            // crystal
            my_cells[row][col].cc = (Crystal::Color) atoi( my_line.c_str() );
            my_line.erase( 0, my_line.find(',') + 1 );
            
            // bonus
            my_cells[row][col].bt = (BonusType) atoi( my_line.c_str() );
        } // for col
        
        // These also need initializing for each row:
        my_data.dxs[row] = 0;
        my_data.pixels_carried_over_x[row] = 0.0f;
    } // for row
    
} // FS::Scroller::load_data

// **************************************************

void FS::Scroller::update(int t)
{
    float pixels_to_move_x;
    
    for (int row = 0; row < NUM_ROWS; ++row)
    {
        pixels_to_move_x = my_data.pixels_carried_over_x[row] +
                (my_data.current_velocities[row] * t);
        my_data.dxs[row] = (int) pixels_to_move_x;
        my_data.pixels_carried_over_x[row] = pixels_to_move_x - my_data.dxs[row];
    } // for
    
} // FS::Scroller::update

// **************************************************

void FS::Scroller::reset_cells()
{
    for ( int row = 0; row < NUM_ROWS; ++row )
    {
        for ( int col = 0; col < MAX_COLS; ++col )
        {
            my_cells[row][col].lc = L_BACKGROUND; 
            my_cells[row][col].cc = Crystal::color_none_c; 
            my_cells[row][col].bt = B_NONE;
        } // for 
    } // for 

} // FS::Scroller::reset_cells       

// **************************************************
