// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Player_data.h"




// *******************
// *** CONSTRUCTOR ***
// *******************
FS::Player_data::Player_data()
{
    /*
    erase_rect.y = CRYSTALS_HELD_Y;
    erase_rect.w = CRYSTAL_WIDTH;
    erase_rect.h = CRYSTAL_HEIGHT;
    
    dest_rect.y = CRYSTALS_HELD_Y;
    
    dirty_rect.x = CRYSTALS_HELD_X_OFFSET;
    dirty_rect.y = CRYSTALS_HELD_Y;        
    dirty_rect.h = CRYSTAL_HEIGHT;
    */

    score_update_rect.x = 191;
    score_update_rect.y = 9;
    score_update_rect.w = 70;
    score_update_rect.h = 15;
    
    score_dest_rect.x = 190;
    score_dest_rect.y = 4;
    
    lives_update_rect.x = 41;
    lives_update_rect.y = 9;
    lives_update_rect.w = 10;
    lives_update_rect.h = 15;
    
    lives_dest_rect.x = 40;
    lives_dest_rect.y = 4;
    
    level_update_rect.x = 707;
    level_update_rect.y = 9;
    level_update_rect.w = 22;
    level_update_rect.h = 15;
    
    level_dest_rect.x = 706;
    level_dest_rect.y = 4;
    
} // FS::Player_data::Player_data

// ******************
// *** DESTRUCTOR ***
// ******************
FS::Player_data::~Player_data() {}




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************
        
void FS::Player_data::reset(int start_level)
{
    level = start_level;  // levels start at ONE!!!
    num_lives = STARTING_NUM_LIVES;
    score = 0;
    
} // FS::Player_data::reset
     
// **************************************************

void FS::Player_data::set_max_crystals(int mc)
{
    max_crystals = mc;
    
    // This only needs to be set once at the start of each new level.     
    /*dirty_rect.w = (max_crystals * CRYSTAL_WIDTH) + 
            ((max_crystals - 1) * CRYSTALS_HELD_X_GAP);*/
    
} // FS::Player_data::set_max_crystals
        
// **************************************************

bool FS::Player_data::is_allowed_on_log(LogColor lc)
{
    bool is_ok = false;
            
    switch (lc)
    {
        case L_RED:
        case L_YELLOW:
        case L_BLUE:
            crystals_iter = std::find(crystals.begin(), crystals.end(), (Crystal::Color) lc);
            if (crystals_iter != crystals.end())
            {
                crystals.erase(crystals_iter);
                is_ok = true;
                break;
            } // if
            break;
            
        case L_ORANGE:
            is_ok = check_crystals(Crystal::color_red_c, Crystal::color_yellow_c);
            break;
            
        case L_GREEN:
            is_ok = check_crystals(Crystal::color_blue_c, Crystal::color_yellow_c);
            break;
            
        case L_PURPLE:
            is_ok = check_crystals(Crystal::color_blue_c, Crystal::color_red_c);
            break;
            
        case L_BROWN:
            is_ok = true;
            break;
            
        // Should never happen - just to avoid warnings from compiler...
        case L_BACKGROUND:
            break;
            
    } // switch

    // If we haven't got an exact colour-match, is there a white
    // crystal to save the day?
    if (!is_ok)
    {
        crystals_iter = find(crystals.begin(), crystals.end(), Crystal::color_white_c);
        if (crystals_iter != crystals.end())
        {
            crystals.erase(crystals_iter);
            is_ok = true;
        } // if
    } // if
            
    return is_ok;
    
} // FS::Player_data::is_allowed_on_log
    
// **************************************************

bool FS::Player_data::check_crystals(Crystal::Color color_0, Crystal::Color color_1)
{
    // We need TWO iterators for this function.
    std::list<Crystal::Color>::iterator iter_0;
    std::list<Crystal::Color>::iterator iter_1;
    
    iter_0 = find(crystals.begin(), crystals.end(), color_0);
    iter_1 = find(crystals.begin(), crystals.end(), color_1);
    
    if ( iter_0 != crystals.end() && iter_1 != crystals.end() )
    {
        crystals.erase(iter_0);
        crystals.erase(iter_1);
        return true;
    } 
    else
    {
        return false;
    } // if ... else
    
} // FS::Player_data::check_crystals
    
// **************************************************

FS::Crystal::Color FS::Player_data::add_crystal(Crystal::Color cc)
{
    // Simple case - see if we've already got a spare 'slot'.
    if ( crystals.size() < max_crystals )
    {
        crystals.push_back(cc);
        return Crystal::color_none_c;  // nothing swapped
    } // if
    
    // No spare slot, so pop front (and return) and push new 
    // crystal to back.
    Crystal::Color removed = crystals.front();
    crystals.pop_front();
    crystals.push_back(cc);
    return removed;
    
} // FS::Player_data::add_crystal 

// **************************************************

// FIXME: a bit of hackery here (separate index, inefficient erasing).
void FS::Player_data::draw_crystals_held()
{
    int i = 0;
    BOOST_FOREACH ( Crystal::Color c, crystals )
    {
        gfx_ptr->draw_texture( c + 38, i * CELL_WIDTH + i * CRYSTALS_HELD_X_GAP, CRYSTALS_HELD_Y );
        ++i;
    } // BOOST_FOREACH

} // FS::Player_data::draw_crystals_held

// **************************************************

void FS::Player_data::set_crystals_held(Crystal::Color * ccs, int n)
{
    crystals.clear();
    for (int i = 0; i < n; ++i)
    {
        crystals.push_back(ccs[i]);
    } // for

} // FS::Player_data::set_crystals_held

// **************************************************

// Returns true if there's another level to play, otherwise false.
bool FS::Player_data::inc_level()
{
    ++level;
    return true;
    
} // FS::Player_data::inc_level

// **************************************************

void FS::Player_data::draw_score()
{
    sprintf(score_str, "%06d", score);
    gfx_ptr->draw_text(FS_gfx::WHITE_FONT, score_dest_rect.x, score_dest_rect.y, score_str);

} // FS::Player_data::draw_score
  
// **************************************************

void FS::Player_data::draw_lives()
{
    sprintf(lives_str, "%d", num_lives);
    gfx_ptr->draw_text(FS_gfx::WHITE_FONT, lives_dest_rect.x, lives_dest_rect.y, lives_str);

} // FS::Player_data::draw_lives

// **************************************************

void FS::Player_data::draw_level()
{
    sprintf(level_str, "%d", level);
    gfx_ptr->draw_text(FS_gfx::WHITE_FONT, level_dest_rect.x, level_dest_rect.y, level_str);

} // FS::Player_data::draw_level

// **************************************************

bool FS::Player_data::check_crystals(const Crystal::Color* ccs, int n)
{
    // Simple case - we don't need any crystals!
    if ( n == 0 ) { return true; }
    
    // First, need a copy of 'crystals' list.
    std::list<Crystal::Color> crystals_copy(crystals.begin(), crystals.end());
    
    bool found_all = true;
    for (int i = 0; i < n; ++i)
    {
        crystals_iter = find(crystals_copy.begin(), crystals_copy.end(), ccs[i]);
        if ( crystals_iter == crystals_copy.end() ) 
        {
            // didn't find crystal - so exit loop and return false
            found_all = false;
            break;
        }
        else
        {
            // found crystal, so remove it from list ready for next search
            crystals_copy.erase(crystals_iter);
        } // if ... else
    } // for
    
    return found_all;
    
} // FS::Player_data::check_crystals

// **************************************************

void FS::Player_data::print_crystals_held() const
{
    std::cout << "Crystals held: ";
    
    std::list<Crystal::Color>::const_iterator c_iter = crystals.begin();
    while (c_iter != crystals.end())
    {
        std::cout << *c_iter << ",";
        ++c_iter;
    } // while
    std::cout << std::endl;
    
} // FS::Player_data::print_crystals_held

    
    






 
