// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Play_h
#define Play_h




#include "Sprite_manager.h"
#include "Player_data.h"
#include <fstream>
#include <cstdio>
#include <cstdlib>
#include <iostream>
#include "enums.h"
#include "Sound_engine.h"
#include "constants.h"
#include <string>
#include "Scroller.h"
#include "Game_timer.h"
#include "Pause_menu.h"
#include "Tutorial.h"
#include <boost/lexical_cast.hpp>




extern bool test_level;
extern char* test_file;
// This bool allows Albert and Play to communicate with each other.
extern bool escape_pressed;
extern FS::Mode current_mode;




namespace FS
{

    
class Play
{
    public:
    
        // PAUSE_AUTO only in MODE_TUTORIAL - game has been automatically
        // paused by program.        
        //enum PauseType { PAUSE_NONE, PAUSE_USER, PAUSE_AUTO };
    
        Play( GameTimer* _timer_ptr );
        ~Play();
        
        void init_sprite_manager(Sound_engine* se);
        
        void new_game(int start_level = 1);
        void new_level(int st);
                
        PlayReport update(int gt);
        
        int get_level() const { return my_player_data.get_level(); }
        int get_score() const { return my_player_data.get_score(); }

    private:
            
        Sprite_manager my_sprite_mngr;
        Player_data my_player_data;
        Scroller my_scroller;
        Pause_menu my_pause_menu;
        GameTimer* timer_ptr;
        Tutorial my_tutorial;
        Sound_engine* snd_engine_ptr;
        
        int start_time;
        
        void load_level(int lev);    
        
        int num_starting_crystals;
        // FIXME: need a symbolic constant!
        Crystal::Color starting_crystals[5];
        
        int current_update_time;
        int previous_update_time;
        
        void handle_escape_pressed( PlayReport report );
        
        void check_task();
        //void display_task_msg(const Tutorial::Task* task);
        bool have_drawn_reminder;
        
        PauseType my_pause;
        
}; // class Play

} // namespace FS




#endif

