/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.security.auth.x500.X500Principal;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMEncryptor;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcePEMEncryptorBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cli.EnvironmentAwareCommand;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.ssl.PemUtils;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ssl.CertParsingUtils;
import org.elasticsearch.xpack.security.cli.CertGenUtils;

@Deprecated
class CertificateGenerateTool
extends EnvironmentAwareCommand {
    private static final String AUTO_GEN_CA_DN = "CN=Elastic Certificate Tool Autogenerated CA";
    private static final String DESCRIPTION = "Simplifies certificate creation for use with the Elastic Stack";
    private static final String DEFAULT_CSR_FILE = "csr-bundle.zip";
    private static final String DEFAULT_CERT_FILE = "certificate-bundle.zip";
    private static final int DEFAULT_DAYS = 1095;
    private static final int FILE_EXTENSION_LENGTH = 4;
    static final int MAX_FILENAME_LENGTH = 251;
    private static final Pattern ALLOWED_FILENAME_CHAR_PATTERN = Pattern.compile("[a-zA-Z0-9!@#$%^&{}\\[\\]()_+\\-=,.~'` ]{1,251}");
    private static final int DEFAULT_KEY_SIZE = 2048;
    private static final BouncyCastleProvider BC_PROV = new BouncyCastleProvider();
    private final OptionSpec<String> outputPathSpec;
    private final OptionSpec<Void> csrSpec;
    private final OptionSpec<String> caCertPathSpec;
    private final OptionSpec<String> caKeyPathSpec;
    private final OptionSpec<String> caPasswordSpec;
    private final OptionSpec<String> caDnSpec;
    private final OptionSpec<Integer> keysizeSpec;
    private final OptionSpec<String> inputFileSpec;
    private final OptionSpec<Integer> daysSpec;
    private final ArgumentAcceptingOptionSpec<String> p12Spec;

    CertificateGenerateTool() {
        super(DESCRIPTION);
        this.outputPathSpec = this.parser.accepts("out", "path of the zip file that the output should be written to").withRequiredArg();
        this.csrSpec = this.parser.accepts("csr", "only generate certificate signing requests");
        this.caCertPathSpec = this.parser.accepts("cert", "path to an existing ca certificate").availableUnless(this.csrSpec, new OptionSpec[0]).withRequiredArg();
        this.caKeyPathSpec = this.parser.accepts("key", "path to an existing ca private key").availableIf(this.caCertPathSpec, new OptionSpec[0]).requiredIf(this.caCertPathSpec, new OptionSpec[0]).withRequiredArg();
        this.caPasswordSpec = this.parser.accepts("pass", "password for an existing ca private key or the generated ca private key").availableUnless(this.csrSpec, new OptionSpec[0]).withOptionalArg();
        this.caDnSpec = this.parser.accepts("dn", "distinguished name to use for the generated ca. defaults to CN=Elastic Certificate Tool Autogenerated CA").availableUnless(this.caCertPathSpec, new OptionSpec[0]).availableUnless(this.csrSpec, new OptionSpec[0]).withRequiredArg();
        this.keysizeSpec = this.parser.accepts("keysize", "size in bits of RSA keys").withRequiredArg().ofType(Integer.class);
        this.inputFileSpec = this.parser.accepts("in", "file containing details of the instances in yaml format").withRequiredArg();
        this.daysSpec = this.parser.accepts("days", "number of days that the generated certificates are valid").availableUnless(this.csrSpec, new OptionSpec[0]).withRequiredArg().ofType(Integer.class);
        this.p12Spec = this.parser.accepts("p12", "output a p12 (PKCS#12) version for each certificate/key pair, with optional password").availableUnless(this.csrSpec, new OptionSpec[0]).withOptionalArg();
    }

    public void execute(Terminal terminal, OptionSet options, Environment env, ProcessInfo processInfo) throws Exception {
        int keysize;
        boolean csrOnly = options.has(this.csrSpec);
        CertificateGenerateTool.printIntro(terminal, csrOnly);
        Path outputFile = CertificateGenerateTool.getOutputFile(terminal, (String)this.outputPathSpec.value(options), csrOnly ? DEFAULT_CSR_FILE : DEFAULT_CERT_FILE);
        String inputFile = (String)this.inputFileSpec.value(options);
        int n = keysize = options.has(this.keysizeSpec) ? (Integer)this.keysizeSpec.value(options) : 2048;
        if (csrOnly) {
            Collection<CertificateInformation> certificateInformations = CertificateGenerateTool.getCertificateInformationList(terminal, inputFile);
            CertificateGenerateTool.generateAndWriteCsrs(outputFile, certificateInformations, keysize);
        } else {
            int days;
            String dn = options.has(this.caDnSpec) ? (String)this.caDnSpec.value(options) : AUTO_GEN_CA_DN;
            boolean prompt = options.has(this.caPasswordSpec);
            char[] keyPass = options.hasArgument(this.caPasswordSpec) ? ((String)this.caPasswordSpec.value(options)).toCharArray() : null;
            int n2 = days = options.hasArgument(this.daysSpec) ? (Integer)this.daysSpec.value(options) : 1095;
            Object p12Password = options.hasArgument(this.p12Spec) ? ((String)this.p12Spec.value(options)).toCharArray() : (Object)(options.has(this.p12Spec) ? new char[]{} : null);
            CAInfo caInfo = CertificateGenerateTool.getCAInfo(terminal, dn, (String)this.caCertPathSpec.value(options), (String)this.caKeyPathSpec.value(options), keyPass, prompt, env, keysize, days);
            Collection<CertificateInformation> certificateInformations = CertificateGenerateTool.getCertificateInformationList(terminal, inputFile);
            CertificateGenerateTool.generateAndWriteSignedCertificates(outputFile, certificateInformations, caInfo, keysize, days, p12Password);
        }
        CertificateGenerateTool.printConclusion(terminal, csrOnly, outputFile);
    }

    protected void printAdditionalHelp(Terminal terminal) {
        terminal.println((CharSequence)"Simplifies the generation of certificate signing requests and signed");
        terminal.println((CharSequence)"certificates. The tool runs interactively unless the 'in' and 'out' parameters");
        terminal.println((CharSequence)"are specified. In the interactive mode, the tool will prompt for required");
        terminal.println((CharSequence)"values that have not been provided through the use of command line options.");
        terminal.println((CharSequence)"");
    }

    static Path getOutputFile(Terminal terminal, String outputPath, String defaultFilename) throws IOException {
        Path file;
        if (outputPath != null) {
            file = CertificateGenerateTool.resolvePath(outputPath);
        } else {
            file = CertificateGenerateTool.resolvePath(defaultFilename);
            String input = terminal.readText("Please enter the desired output file [" + String.valueOf(file) + "]: ");
            if (!input.isEmpty()) {
                file = CertificateGenerateTool.resolvePath(input);
            }
        }
        return file.toAbsolutePath();
    }

    @SuppressForbidden(reason="resolve paths against CWD for a CLI tool")
    private static Path resolvePath(String pathStr) {
        return PathUtils.get((String)pathStr, (String[])new String[0]).normalize();
    }

    static Collection<CertificateInformation> getCertificateInformationList(Terminal terminal, String inputFile) throws Exception {
        if (inputFile != null) {
            return CertificateGenerateTool.parseAndValidateFile(terminal, CertificateGenerateTool.resolvePath(inputFile).toAbsolutePath());
        }
        HashMap<String, CertificateInformation> map = new HashMap<String, CertificateInformation>();
        boolean done = false;
        while (!done) {
            String exit;
            String name = terminal.readText("Enter instance name: ");
            if (!name.isEmpty()) {
                List<String> commonNames;
                List<String> dnsList;
                boolean isNameValidFilename = Name.isValidFilename(name);
                String filename = terminal.readText("Enter name for directories and files " + (String)(isNameValidFilename ? "[" + name + "]" : "") + ": ");
                if (filename.isEmpty() && isNameValidFilename) {
                    filename = name;
                }
                String ipAddresses = terminal.readText("Enter IP Addresses for instance (comma-separated if more than one) []: ");
                String dnsNames = terminal.readText("Enter DNS names for instance (comma-separated if more than one) []: ");
                List<String> ipList = Arrays.asList(Strings.splitStringByCommaToArray((String)ipAddresses));
                CertificateInformation information = new CertificateInformation(name, filename, ipList, dnsList = Arrays.asList(Strings.splitStringByCommaToArray((String)dnsNames)), commonNames = null);
                List<String> validationErrors = information.validate();
                if (validationErrors.isEmpty()) {
                    if (map.containsKey(name)) {
                        terminal.println((CharSequence)("Overwriting previously defined instance information [" + name + "]"));
                    }
                    map.put(name, information);
                } else {
                    for (String validationError : validationErrors) {
                        terminal.println((CharSequence)validationError);
                    }
                    terminal.println((CharSequence)"Skipping entry as invalid values were found");
                }
            } else {
                terminal.println((CharSequence)"A name must be provided");
            }
            if ("y".equals(exit = terminal.readText("Would you like to specify another instance? Press 'y' to continue entering instance information: "))) continue;
            done = true;
        }
        return map.values();
    }

    static Collection<CertificateInformation> parseAndValidateFile(Terminal terminal, Path file) throws Exception {
        Collection<CertificateInformation> config = CertificateGenerateTool.parseFile(file);
        boolean hasError = false;
        for (CertificateInformation certInfo : config) {
            List<String> errors = certInfo.validate();
            if (errors.size() <= 0) continue;
            hasError = true;
            terminal.errorPrintln(Terminal.Verbosity.SILENT, "Configuration for instance " + certInfo.name.originalName + " has invalid details");
            for (String message : errors) {
                terminal.errorPrintln(Terminal.Verbosity.SILENT, " * " + message);
            }
            terminal.errorPrintln("");
        }
        if (hasError) {
            throw new UserException(78, "File " + String.valueOf(file) + " contains invalid configuration details (see messages above)");
        }
        return config;
    }

    static Collection<CertificateInformation> parseFile(Path file) throws Exception {
        try (BufferedReader reader = Files.newBufferedReader(file);){
            Collection collection;
            block12: {
                XContentParser xContentParser = XContentType.YAML.xContent().createParser(XContentParserConfiguration.EMPTY, (Reader)reader);
                try {
                    collection = (Collection)InputFileParser.PARSER.parse(xContentParser, new ArrayList(), null);
                    if (xContentParser == null) break block12;
                }
                catch (Throwable throwable) {
                    if (xContentParser != null) {
                        try {
                            xContentParser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                xContentParser.close();
            }
            return collection;
        }
    }

    static void generateAndWriteCsrs(Path outputFile, Collection<CertificateInformation> certInfo, int keysize) throws Exception {
        CertificateGenerateTool.fullyWriteFile(outputFile, (outputStream, pemWriter) -> {
            for (CertificateInformation certificateInformation : certInfo) {
                KeyPair keyPair = CertGenUtils.generateKeyPair(keysize);
                GeneralNames sanList = CertificateGenerateTool.getSubjectAlternativeNamesValue(certificateInformation.ipAddresses, certificateInformation.dnsNames, certificateInformation.commonNames);
                PKCS10CertificationRequest csr = CertGenUtils.generateCSR(keyPair, certificateInformation.name.x500Principal, sanList);
                String dirName = certificateInformation.name.filename + "/";
                ZipEntry zipEntry = new ZipEntry(dirName);
                assert (zipEntry.isDirectory());
                outputStream.putNextEntry(zipEntry);
                outputStream.putNextEntry(new ZipEntry(dirName + certificateInformation.name.filename + ".csr"));
                pemWriter.writeObject((Object)csr);
                pemWriter.flush();
                outputStream.closeEntry();
                outputStream.putNextEntry(new ZipEntry(dirName + certificateInformation.name.filename + ".key"));
                pemWriter.writeObject((Object)keyPair.getPrivate());
                pemWriter.flush();
                outputStream.closeEntry();
            }
        });
    }

    static CAInfo getCAInfo(Terminal terminal, String dn, String caCertPath, String caKeyPath, char[] keyPass, boolean prompt, Environment env, int keysize, int days) throws Exception {
        if (caCertPath != null) {
            assert (caKeyPath != null);
            Path resolvedCaCert = CertificateGenerateTool.resolvePath(caCertPath);
            X509Certificate caCert = CertParsingUtils.readX509Certificate((Path)resolvedCaCert);
            PrivateKey privateKey = CertificateGenerateTool.readPrivateKey(caKeyPath, keyPass, terminal, prompt);
            return new CAInfo(caCert, privateKey);
        }
        X500Principal x500Principal = new X500Principal(dn);
        KeyPair keyPair = CertGenUtils.generateKeyPair(keysize);
        X509Certificate caCert = CertGenUtils.generateCACertificate(x500Principal, keyPair, days, null);
        char[] password = prompt ? terminal.readSecret("Enter password for CA private key: ") : keyPass;
        return new CAInfo(caCert, keyPair.getPrivate(), true, password);
    }

    static void generateAndWriteSignedCertificates(Path outputFile, Collection<CertificateInformation> certificateInformations, CAInfo caInfo, int keysize, int days, char[] pkcs12Password) throws Exception {
        CertificateGenerateTool.fullyWriteFile(outputFile, (outputStream, pemWriter) -> {
            CertificateGenerateTool.writeCAInfoIfGenerated(outputStream, pemWriter, caInfo);
            for (CertificateInformation certificateInformation : certificateInformations) {
                KeyPair keyPair = CertGenUtils.generateKeyPair(keysize);
                X509Certificate certificate = CertGenUtils.generateSignedCertificate(certificateInformation.name.x500Principal, CertificateGenerateTool.getSubjectAlternativeNamesValue(certificateInformation.ipAddresses, certificateInformation.dnsNames, certificateInformation.commonNames), keyPair, caInfo.caCert, caInfo.privateKey, days);
                String dirName = certificateInformation.name.filename + "/";
                ZipEntry zipEntry = new ZipEntry(dirName);
                assert (zipEntry.isDirectory());
                outputStream.putNextEntry(zipEntry);
                String entryBase = dirName + certificateInformation.name.filename;
                outputStream.putNextEntry(new ZipEntry(entryBase + ".crt"));
                pemWriter.writeObject((Object)certificate);
                pemWriter.flush();
                outputStream.closeEntry();
                outputStream.putNextEntry(new ZipEntry(entryBase + ".key"));
                pemWriter.writeObject((Object)keyPair.getPrivate());
                pemWriter.flush();
                outputStream.closeEntry();
                if (pkcs12Password == null) continue;
                KeyStore pkcs12 = KeyStore.getInstance("PKCS12");
                pkcs12.load(null);
                pkcs12.setKeyEntry(certificateInformation.name.originalName, keyPair.getPrivate(), pkcs12Password, new Certificate[]{certificate});
                outputStream.putNextEntry(new ZipEntry(entryBase + ".p12"));
                pkcs12.store(outputStream, pkcs12Password);
                outputStream.closeEntry();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fullyWriteFile(Path file, Writer writer) throws Exception {
        boolean success = false;
        try (OutputStream outputStream = Files.newOutputStream(file, StandardOpenOption.CREATE_NEW);
             ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream, StandardCharsets.UTF_8);
             JcaPEMWriter pemWriter = new JcaPEMWriter((java.io.Writer)new OutputStreamWriter((OutputStream)zipOutputStream, StandardCharsets.UTF_8));){
            writer.write(zipOutputStream, pemWriter);
            PosixFileAttributeView view = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0]);
            if (view != null) {
                view.setPermissions(Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE}));
            }
            success = true;
        }
        finally {
            if (!success) {
                Files.deleteIfExists(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCAInfoIfGenerated(ZipOutputStream outputStream, JcaPEMWriter pemWriter, CAInfo info) throws Exception {
        if (info.generated) {
            String caDirName = "ca/";
            ZipEntry zipEntry = new ZipEntry("ca/");
            assert (zipEntry.isDirectory());
            outputStream.putNextEntry(zipEntry);
            outputStream.putNextEntry(new ZipEntry("ca/ca.crt"));
            pemWriter.writeObject((Object)info.caCert);
            pemWriter.flush();
            outputStream.closeEntry();
            outputStream.putNextEntry(new ZipEntry("ca/ca.key"));
            if (info.password != null && info.password.length > 0) {
                try {
                    PEMEncryptor encryptor = new JcePEMEncryptorBuilder("DES-EDE3-CBC").setProvider((Provider)BC_PROV).build(info.password);
                    pemWriter.writeObject((Object)info.privateKey, encryptor);
                }
                finally {
                    Arrays.fill(info.password, '\u0000');
                }
            } else {
                pemWriter.writeObject((Object)info.privateKey);
            }
            pemWriter.flush();
            outputStream.closeEntry();
        }
    }

    private static void printIntro(Terminal terminal, boolean csr) {
        terminal.println((CharSequence)"******************************************************************************");
        terminal.println((CharSequence)"Note: The 'elasticsearch-certgen' tool has been deprecated in favour of the");
        terminal.println((CharSequence)"      'elasticsearch-certutil' tool. This command will be removed in a future");
        terminal.println((CharSequence)"      release.");
        terminal.println((CharSequence)"******************************************************************************");
        terminal.println((CharSequence)"");
        terminal.println((CharSequence)"This tool assists you in the generation of X.509 certificates and certificate");
        terminal.println((CharSequence)"signing requests for use with SSL in the Elastic stack. Depending on the command");
        terminal.println((CharSequence)"line option specified, you may be prompted for the following:");
        terminal.println((CharSequence)"");
        terminal.println((CharSequence)"* The path to the output file");
        if (csr) {
            terminal.println((CharSequence)"    * The output file is a zip file containing the certificate signing requests");
            terminal.println((CharSequence)"      and private keys for each instance.");
        } else {
            terminal.println((CharSequence)"    * The output file is a zip file containing the signed certificates and");
            terminal.println((CharSequence)"      private keys for each instance. If a Certificate Authority was generated,");
            terminal.println((CharSequence)"      the certificate and private key will also be included in the output file.");
        }
        terminal.println((CharSequence)"* Information about each instance");
        terminal.println((CharSequence)"    * An instance is any piece of the Elastic Stack that requires an SSL certificate.");
        terminal.println((CharSequence)"      Depending on your configuration, Elasticsearch, Logstash, Kibana, and Beats");
        terminal.println((CharSequence)"      may all require a certificate and private key.");
        terminal.println((CharSequence)"    * The minimum required value for each instance is a name. This can simply be the");
        terminal.println((CharSequence)"      hostname, which will be used as the Common Name of the certificate. A full");
        terminal.println((CharSequence)"      distinguished name may also be used.");
        terminal.println((CharSequence)"    * A filename value may be required for each instance. This is necessary when the");
        terminal.println((CharSequence)"      name would result in an invalid file or directory name. The name provided here");
        terminal.println((CharSequence)"      is used as the directory name (within the zip) and the prefix for the key and");
        terminal.println((CharSequence)"      certificate files. The filename is required if you are prompted and the name");
        terminal.println((CharSequence)"      is not displayed in the prompt.");
        terminal.println((CharSequence)"    * IP addresses and DNS names are optional. Multiple values can be specified as a");
        terminal.println((CharSequence)"      comma separated string. If no IP addresses or DNS names are provided, you may");
        terminal.println((CharSequence)"      disable hostname verification in your SSL configuration.");
        if (!csr) {
            terminal.println((CharSequence)"* Certificate Authority private key password");
            terminal.println((CharSequence)"    * The password may be left empty if desired.");
        }
        terminal.println((CharSequence)"");
        terminal.println((CharSequence)"Let's get started...");
        terminal.println((CharSequence)"");
    }

    private static void printConclusion(Terminal terminal, boolean csr, Path outputFile) {
        if (csr) {
            terminal.println((CharSequence)("Certificate signing requests written to " + String.valueOf(outputFile)));
            terminal.println((CharSequence)"");
            terminal.println((CharSequence)"This file should be properly secured as it contains the private keys for all");
            terminal.println((CharSequence)"instances.");
            terminal.println((CharSequence)"");
            terminal.println((CharSequence)"After unzipping the file, there will be a directory for each instance containing");
            terminal.println((CharSequence)"the certificate signing request and the private key. Provide the certificate");
            terminal.println((CharSequence)"signing requests to your certificate authority. Once you have received the");
            terminal.println((CharSequence)"signed certificate, copy the signed certificate, key, and CA certificate to the");
            terminal.println((CharSequence)"configuration directory of the Elastic product that they will be used for and");
            terminal.println((CharSequence)"follow the SSL configuration instructions in the product guide.");
        } else {
            terminal.println((CharSequence)("Certificates written to " + String.valueOf(outputFile)));
            terminal.println((CharSequence)"");
            terminal.println((CharSequence)"This file should be properly secured as it contains the private keys for all");
            terminal.println((CharSequence)"instances and the certificate authority.");
            terminal.println((CharSequence)"");
            terminal.println((CharSequence)"After unzipping the file, there will be a directory for each instance containing");
            terminal.println((CharSequence)"the certificate and private key. Copy the certificate, key, and CA certificate");
            terminal.println((CharSequence)"to the configuration directory of the Elastic product that they will be used for");
            terminal.println((CharSequence)"and follow the SSL configuration instructions in the product guide.");
            terminal.println((CharSequence)"");
            terminal.println((CharSequence)"For client applications, you may only need to copy the CA certificate and");
            terminal.println((CharSequence)"configure the client to trust this certificate.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readPrivateKey(String path, char[] password, Terminal terminal, boolean prompt) throws Exception {
        AtomicReference<char[]> passwordReference = new AtomicReference<char[]>(password);
        try {
            PrivateKey privateKey = PemUtils.readPrivateKey((Path)CertificateGenerateTool.resolvePath(path), () -> {
                if (password != null || !prompt) {
                    return password;
                }
                char[] promptedValue = terminal.readSecret("Enter password for CA private key: ");
                passwordReference.set(promptedValue);
                return promptedValue;
            });
            return privateKey;
        }
        finally {
            if (passwordReference.get() != null) {
                Arrays.fill(passwordReference.get(), '\u0000');
            }
        }
    }

    private static GeneralNames getSubjectAlternativeNamesValue(List<String> ipAddresses, List<String> dnsNames, List<String> commonNames) {
        HashSet<GeneralName> generalNameList = new HashSet<GeneralName>();
        for (String ip : ipAddresses) {
            generalNameList.add(new GeneralName(7, ip));
        }
        for (String dns : dnsNames) {
            generalNameList.add(new GeneralName(2, dns));
        }
        for (String cn : commonNames) {
            generalNameList.add(CertGenUtils.createCommonName(cn));
        }
        if (generalNameList.isEmpty()) {
            return null;
        }
        return new GeneralNames(generalNameList.toArray(new GeneralName[0]));
    }

    static class CAInfo {
        final X509Certificate caCert;
        final PrivateKey privateKey;
        final boolean generated;
        final char[] password;

        CAInfo(X509Certificate caCert, PrivateKey privateKey) {
            this(caCert, privateKey, false, null);
        }

        CAInfo(X509Certificate caCert, PrivateKey privateKey, boolean generated, char[] password) {
            this.caCert = caCert;
            this.privateKey = privateKey;
            this.generated = generated;
            this.password = password;
        }
    }

    static class Name {
        final String originalName;
        final X500Principal x500Principal;
        final String filename;
        final String error;

        private Name(String name, X500Principal x500Principal, String filename, String error) {
            this.originalName = name;
            this.x500Principal = x500Principal;
            this.filename = filename;
            this.error = error;
        }

        static Name fromUserProvidedName(String name, String filename) {
            X500Principal principal;
            if ("ca".equals(name)) {
                return new Name(name, null, null, "[ca] may not be used as an instance name");
            }
            try {
                principal = name.contains("=") ? new X500Principal(name) : new X500Principal("CN=" + name);
            }
            catch (IllegalArgumentException e) {
                String error = "[" + name + "] could not be converted to a valid DN\n" + e.getMessage() + "\n" + ExceptionsHelper.stackTrace((Throwable)e);
                return new Name(name, null, null, error);
            }
            boolean validFilename = Name.isValidFilename(filename);
            if (!validFilename) {
                return new Name(name, principal, null, "[" + filename + "] is not a valid filename");
            }
            return new Name(name, principal, CertificateGenerateTool.resolvePath(filename).toString(), null);
        }

        static boolean isValidFilename(String name) {
            return ALLOWED_FILENAME_CHAR_PATTERN.matcher(name).matches() && ALLOWED_FILENAME_CHAR_PATTERN.matcher(CertificateGenerateTool.resolvePath(name).toString()).matches() && !name.startsWith(".");
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{original=[" + this.originalName + "] principal=[" + String.valueOf(this.x500Principal) + "] file=[" + this.filename + "] err=[" + this.error + "]}";
        }
    }

    static class CertificateInformation {
        final Name name;
        final List<String> ipAddresses;
        final List<String> dnsNames;
        final List<String> commonNames;

        CertificateInformation(String name, String filename, List<String> ipAddresses, List<String> dnsNames, List<String> commonNames) {
            this.name = Name.fromUserProvidedName(name, filename);
            this.ipAddresses = ipAddresses == null ? Collections.emptyList() : ipAddresses;
            this.dnsNames = dnsNames == null ? Collections.emptyList() : dnsNames;
            this.commonNames = commonNames == null ? Collections.emptyList() : commonNames;
        }

        List<String> validate() {
            ArrayList<String> errors = new ArrayList<String>();
            if (this.name.error != null) {
                errors.add(this.name.error);
            }
            for (String ip : this.ipAddresses) {
                if (InetAddresses.isInetAddress((String)ip)) continue;
                errors.add("[" + ip + "] is not a valid IP address");
            }
            for (String dnsName : this.dnsNames) {
                if (DERIA5String.isIA5String((String)dnsName)) continue;
                errors.add("[" + dnsName + "] is not a valid DNS name");
            }
            return errors;
        }
    }

    private static class InputFileParser {
        private static final ObjectParser<List<CertificateInformation>, Void> PARSER = new ObjectParser("certgen");

        private InputFileParser() {
        }

        static {
            ConstructingObjectParser instanceParser = new ConstructingObjectParser("instances", a -> new CertificateInformation((String)a[0], (String)(a[1] == null ? a[0] : a[1]), (List)a[2], (List)a[3], (List)a[4]));
            instanceParser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
            instanceParser.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("filename", new String[0]));
            instanceParser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("ip", new String[0]));
            instanceParser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("dns", new String[0]));
            instanceParser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("cn", new String[0]));
            PARSER.declareObjectArray(List::addAll, (ContextParser)instanceParser, new ParseField("instances", new String[0]));
        }
    }

    private static interface Writer {
        public void write(ZipOutputStream var1, JcaPEMWriter var2) throws Exception;
    }
}

