/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.Describable;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.aggregation.GroupingAggregator;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class HashAggregationOperator
implements Operator {
    private boolean finished;
    private Page output;
    private final BlockHash blockHash;
    private final List<GroupingAggregator> aggregators;
    private final DriverContext driverContext;
    private long hashNanos;
    private long aggregationNanos;
    private int pagesProcessed;
    private long rowsReceived;
    private long rowsEmitted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashAggregationOperator(List<GroupingAggregator.Factory> aggregators, Supplier<BlockHash> blockHash, DriverContext driverContext) {
        this.aggregators = new ArrayList<GroupingAggregator>(aggregators.size());
        this.driverContext = driverContext;
        boolean success = false;
        try {
            this.blockHash = blockHash.get();
            for (GroupingAggregator.Factory a : aggregators) {
                this.aggregators.add((GroupingAggregator)a.apply(driverContext));
            }
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInput(Page page) {
        try {
            final GroupingAggregatorFunction.AddInput[] prepared = new GroupingAggregatorFunction.AddInput[this.aggregators.size()];
            class AddInput
            implements GroupingAggregatorFunction.AddInput {
                long hashStart = System.nanoTime();
                long aggStart;

                AddInput() {
                }

                @Override
                public void add(int positionOffset, IntBlock groupIds) {
                    IntVector groupIdsVector = groupIds.asVector();
                    if (groupIdsVector != null) {
                        this.add(positionOffset, groupIdsVector);
                    } else {
                        this.startAggEndHash();
                        for (GroupingAggregatorFunction.AddInput p : prepared) {
                            p.add(positionOffset, groupIds);
                        }
                        this.end();
                    }
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    this.startAggEndHash();
                    for (GroupingAggregatorFunction.AddInput p : prepared) {
                        p.add(positionOffset, groupIds);
                    }
                    this.end();
                }

                private void startAggEndHash() {
                    this.aggStart = System.nanoTime();
                    HashAggregationOperator.this.hashNanos += this.aggStart - this.hashStart;
                }

                private void end() {
                    this.hashStart = System.nanoTime();
                    HashAggregationOperator.this.aggregationNanos += this.hashStart - this.aggStart;
                }

                public void close() {
                    Releasables.closeExpectNoException((Releasable[])prepared);
                }
            }
            try (AddInput add = new AddInput();){
                HashAggregationOperator.checkState(this.needsInput(), "Operator is already finishing");
                Objects.requireNonNull(page, "page is null");
                for (int i = 0; i < prepared.length; ++i) {
                    prepared[i] = this.aggregators.get(i).prepareProcessPage(this.blockHash, page);
                }
                this.blockHash.add(this.wrapPage(page), add);
                this.hashNanos += System.nanoTime() - add.hashStart;
            }
        }
        finally {
            page.releaseBlocks();
            ++this.pagesProcessed;
            this.rowsReceived += (long)page.getPositionCount();
        }
    }

    @Override
    public Page getOutput() {
        Page p = this.output;
        if (p != null) {
            this.rowsEmitted += (long)p.getPositionCount();
        }
        this.output = null;
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        boolean success;
        Releasable[] blocks;
        block7: {
            if (this.finished) {
                return;
            }
            this.finished = true;
            blocks = null;
            IntVector selected = null;
            success = false;
            try {
                selected = this.blockHash.nonEmpty();
                Block[] keys = this.blockHash.getKeys();
                int[] aggBlockCounts = this.aggregators.stream().mapToInt(GroupingAggregator::evaluateBlockCount).toArray();
                blocks = new Block[keys.length + Arrays.stream(aggBlockCounts).sum()];
                System.arraycopy(keys, 0, blocks, 0, keys.length);
                int offset = keys.length;
                for (int i = 0; i < this.aggregators.size(); ++i) {
                    GroupingAggregator aggregator = this.aggregators.get(i);
                    aggregator.evaluate((Block[])blocks, offset, selected, this.driverContext);
                    offset += aggBlockCounts[i];
                }
                this.output = new Page((Block[])blocks);
                success = true;
                if (selected == null) break block7;
            }
            catch (Throwable throwable) {
                if (selected != null) {
                    selected.close();
                }
                if (!success && blocks != null) {
                    Releasables.closeExpectNoException(blocks);
                }
                throw throwable;
            }
            selected.close();
        }
        if (!success && blocks != null) {
            Releasables.closeExpectNoException((Releasable[])blocks);
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.output == null;
    }

    @Override
    public void close() {
        if (this.output != null) {
            this.output.releaseBlocks();
        }
        Releasables.close((Releasable[])new Releasable[]{this.blockHash, () -> Releasables.close(this.aggregators)});
    }

    @Override
    public Operator.Status status() {
        return new Status(this.hashNanos, this.aggregationNanos, this.pagesProcessed, this.rowsReceived, this.rowsEmitted);
    }

    protected static void checkState(boolean condition, String msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }

    protected Page wrapPage(Page page) {
        return page;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("blockHash=").append(this.blockHash).append(", ");
        sb.append("aggregators=").append(this.aggregators);
        sb.append("]");
        return sb.toString();
    }

    public static class Status
    implements Operator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "hashagg", Status::new);
        private final long hashNanos;
        private final long aggregationNanos;
        private final int pagesProcessed;
        private final long rowsReceived;
        private final long rowsEmitted;

        public Status(long hashNanos, long aggregationNanos, int pagesProcessed, long rowsReceived, long rowsEmitted) {
            this.hashNanos = hashNanos;
            this.aggregationNanos = aggregationNanos;
            this.pagesProcessed = pagesProcessed;
            this.rowsReceived = rowsReceived;
            this.rowsEmitted = rowsEmitted;
        }

        protected Status(StreamInput in) throws IOException {
            this.hashNanos = in.readVLong();
            this.aggregationNanos = in.readVLong();
            this.pagesProcessed = in.readVInt();
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_PROFILE_ROWS_PROCESSED)) {
                this.rowsReceived = in.readVLong();
                this.rowsEmitted = in.readVLong();
            } else {
                this.rowsReceived = 0L;
                this.rowsEmitted = 0L;
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.hashNanos);
            out.writeVLong(this.aggregationNanos);
            out.writeVInt(this.pagesProcessed);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_PROFILE_ROWS_PROCESSED)) {
                out.writeVLong(this.rowsReceived);
                out.writeVLong(this.rowsEmitted);
            }
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public long hashNanos() {
            return this.hashNanos;
        }

        public long aggregationNanos() {
            return this.aggregationNanos;
        }

        public int pagesProcessed() {
            return this.pagesProcessed;
        }

        public long rowsReceived() {
            return this.rowsReceived;
        }

        public long rowsEmitted() {
            return this.rowsEmitted;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("hash_nanos", this.hashNanos);
            if (builder.humanReadable()) {
                builder.field("hash_time", (Object)TimeValue.timeValueNanos((long)this.hashNanos));
            }
            builder.field("aggregation_nanos", this.aggregationNanos);
            if (builder.humanReadable()) {
                builder.field("aggregation_time", (Object)TimeValue.timeValueNanos((long)this.aggregationNanos));
            }
            builder.field("pages_processed", this.pagesProcessed);
            builder.field("rows_received", this.rowsReceived);
            builder.field("rows_emitted", this.rowsEmitted);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.hashNanos == status.hashNanos && this.aggregationNanos == status.aggregationNanos && this.pagesProcessed == status.pagesProcessed && this.rowsReceived == status.rowsReceived && this.rowsEmitted == status.rowsEmitted;
        }

        public int hashCode() {
            return Objects.hash(this.hashNanos, this.aggregationNanos, this.pagesProcessed, this.rowsReceived, this.rowsEmitted);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_14_0;
        }
    }

    public record HashAggregationOperatorFactory(List<BlockHash.GroupSpec> groups, AggregatorMode aggregatorMode, List<GroupingAggregator.Factory> aggregators, int maxPageSize, AnalysisRegistry analysisRegistry) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            if (this.groups.stream().anyMatch(BlockHash.GroupSpec::isCategorize)) {
                return new HashAggregationOperator(this.aggregators, () -> BlockHash.buildCategorizeBlockHash(this.groups, this.aggregatorMode, driverContext.blockFactory(), this.analysisRegistry, this.maxPageSize), driverContext);
            }
            return new HashAggregationOperator(this.aggregators, () -> BlockHash.build(this.groups, driverContext.blockFactory(), this.maxPageSize, false), driverContext);
        }

        @Override
        public String describe() {
            return "HashAggregationOperator[mode = <not-needed>, aggs = " + this.aggregators.stream().map(Describable::describe).collect(Collectors.joining(", ")) + "]";
        }
    }
}

