/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data.sort;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.search.sort.SortOrder;

class BucketedSortCommon
implements Releasable {
    final BigArrays bigArrays;
    final SortOrder order;
    final int bucketSize;
    private final BitArray heapMode;

    BucketedSortCommon(BigArrays bigArrays, SortOrder order, int bucketSize) {
        this.bigArrays = bigArrays;
        this.order = order;
        this.bucketSize = bucketSize;
        this.heapMode = new BitArray(0L, bigArrays);
    }

    long rootIndex(int bucket) {
        return (long)bucket * (long)this.bucketSize;
    }

    long endIndex(long rootIndex) {
        return rootIndex + (long)this.bucketSize;
    }

    boolean inHeapMode(int bucket) {
        return this.heapMode.get((long)bucket);
    }

    void enableHeapMode(int bucket) {
        this.heapMode.set((long)bucket);
    }

    void assertValidNextOffset(int next) {
        assert (0 <= next && next < this.bucketSize) : "Expected next to be in the range of valid buckets [0 <= " + next + " < " + this.bucketSize + "]";
    }

    public void close() {
        this.heapMode.close();
    }
}

