/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongLookup;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.LongVectorBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

public final class LongBigArrayVector
extends AbstractVector
implements LongVector,
Releasable {
    private static final long BASE_RAM_BYTES_USED = 0L;
    private final LongArray values;

    public LongBigArrayVector(LongArray values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LongBigArrayVector readArrayVector(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        LongArray values = blockFactory.bigArrays().newLongArray((long)positions, false);
        boolean success = false;
        try {
            values.fillWith(in);
            LongBigArrayVector vector = new LongBigArrayVector(values, positions, blockFactory);
            blockFactory.adjustBreaker(vector.ramBytesUsed() - RamUsageEstimator.sizeOf((Accountable)values));
            success = true;
            LongBigArrayVector longBigArrayVector = vector;
            return longBigArrayVector;
        }
        finally {
            if (!success) {
                values.close();
            }
        }
    }

    void writeArrayVector(int positions, StreamOutput out) throws IOException {
        this.values.writeTo(out);
    }

    @Override
    public LongBlock asBlock() {
        return new LongVectorBlock(this);
    }

    @Override
    public long getLong(int position) {
        return this.values.get((long)position);
    }

    @Override
    public ElementType elementType() {
        return ElementType.LONG;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public long ramBytesUsed() {
        return 0L + RamUsageEstimator.sizeOf((Accountable)this.values);
    }

    @Override
    public LongVector filter(int ... positions) {
        BlockFactory blockFactory = this.blockFactory();
        LongArray filtered = blockFactory.bigArrays().newLongArray((long)positions.length);
        for (int i = 0; i < positions.length; ++i) {
            filtered.set((long)i, this.values.get((long)positions[i]));
        }
        return new LongBigArrayVector(filtered, positions.length, blockFactory);
    }

    @Override
    public LongBlock keepMask(BooleanVector mask) {
        if (this.getPositionCount() == 0) {
            this.incRef();
            return new LongVectorBlock(this);
        }
        if (mask.isConstant()) {
            if (mask.getBoolean(0)) {
                this.incRef();
                return new LongVectorBlock(this);
            }
            return (LongBlock)this.blockFactory().newConstantNullBlock(this.getPositionCount());
        }
        try (LongBlock.Builder builder = this.blockFactory().newLongBlockBuilder(this.getPositionCount());){
            for (int p = 0; p < this.getPositionCount(); ++p) {
                if (mask.getBoolean(p)) {
                    builder.appendLong(this.getLong(p));
                    continue;
                }
                builder.appendNull();
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    public ReleasableIterator<LongBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return new LongLookup(this.asBlock(), positions, targetBlockSize);
    }

    @Override
    public void closeInternal() {
        this.values.close();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LongVector) {
            LongVector that = (LongVector)obj;
            return LongVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LongVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", values=" + String.valueOf(this.values) + "]";
    }
}

