/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentGeoPointDocValuesAggregator;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentStateWrappedLongitudeState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SpatialExtentGeoPointDocValuesAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("top", ElementType.INT), new IntermediateStateDesc("bottom", ElementType.INT), new IntermediateStateDesc("negLeft", ElementType.INT), new IntermediateStateDesc("negRight", ElementType.INT), new IntermediateStateDesc("posLeft", ElementType.INT), new IntermediateStateDesc("posRight", ElementType.INT));
    private final DriverContext driverContext;
    private final SpatialExtentStateWrappedLongitudeState state;
    private final List<Integer> channels;

    public SpatialExtentGeoPointDocValuesAggregatorFunction(DriverContext driverContext, List<Integer> channels, SpatialExtentStateWrappedLongitudeState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static SpatialExtentGeoPointDocValuesAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new SpatialExtentGeoPointDocValuesAggregatorFunction(driverContext, channels, SpatialExtentGeoPointDocValuesAggregator.initSingle());
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (mask.allFalse()) {
            return;
        }
        if (mask.allTrue()) {
            LongBlock block = (LongBlock)page.getBlock(this.channels.get(0));
            LongVector vector = block.asVector();
            if (vector != null) {
                this.addRawVector(vector);
            } else {
                this.addRawBlock(block);
            }
            return;
        }
        LongBlock block = (LongBlock)page.getBlock(this.channels.get(0));
        LongVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector, mask);
        } else {
            this.addRawBlock(block, mask);
        }
    }

    private void addRawVector(LongVector vector) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            SpatialExtentGeoPointDocValuesAggregator.combine(this.state, vector.getLong(i));
        }
    }

    private void addRawVector(LongVector vector, BooleanVector mask) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            if (!mask.getBoolean(i)) continue;
            SpatialExtentGeoPointDocValuesAggregator.combine(this.state, vector.getLong(i));
        }
    }

    private void addRawBlock(LongBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                SpatialExtentGeoPointDocValuesAggregator.combine(this.state, block.getLong(i));
            }
        }
    }

    private void addRawBlock(LongBlock block, BooleanVector mask) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                SpatialExtentGeoPointDocValuesAggregator.combine(this.state, block.getLong(i));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + SpatialExtentGeoPointDocValuesAggregatorFunction.intermediateStateDesc().size());
        Object topUncast = page.getBlock(this.channels.get(0));
        if (topUncast.areAllValuesNull()) {
            return;
        }
        IntVector top = ((IntBlock)topUncast).asVector();
        assert (top.getPositionCount() == 1);
        Object bottomUncast = page.getBlock(this.channels.get(1));
        if (bottomUncast.areAllValuesNull()) {
            return;
        }
        IntVector bottom = ((IntBlock)bottomUncast).asVector();
        assert (bottom.getPositionCount() == 1);
        Object negLeftUncast = page.getBlock(this.channels.get(2));
        if (negLeftUncast.areAllValuesNull()) {
            return;
        }
        IntVector negLeft = ((IntBlock)negLeftUncast).asVector();
        assert (negLeft.getPositionCount() == 1);
        Object negRightUncast = page.getBlock(this.channels.get(3));
        if (negRightUncast.areAllValuesNull()) {
            return;
        }
        IntVector negRight = ((IntBlock)negRightUncast).asVector();
        assert (negRight.getPositionCount() == 1);
        Object posLeftUncast = page.getBlock(this.channels.get(4));
        if (posLeftUncast.areAllValuesNull()) {
            return;
        }
        IntVector posLeft = ((IntBlock)posLeftUncast).asVector();
        assert (posLeft.getPositionCount() == 1);
        Object posRightUncast = page.getBlock(this.channels.get(5));
        if (posRightUncast.areAllValuesNull()) {
            return;
        }
        IntVector posRight = ((IntBlock)posRightUncast).asVector();
        assert (posRight.getPositionCount() == 1);
        SpatialExtentGeoPointDocValuesAggregator.combineIntermediate(this.state, top.getInt(0), bottom.getInt(0), negLeft.getInt(0), negRight.getInt(0), posLeft.getInt(0), posRight.getInt(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = SpatialExtentGeoPointDocValuesAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

