/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.index;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.type.EsField;

public record EsIndex(String name, Map<String, EsField> mapping, Map<String, IndexMode> indexNameWithModes, Set<String> partiallyUnmappedFields) implements Writeable
{
    public EsIndex {
        assert (name != null);
        assert (mapping != null);
        assert (partiallyUnmappedFields != null);
    }

    public EsIndex(String name, Map<String, EsField> mapping, Map<String, IndexMode> indexNameWithModes) {
        this(name, mapping, indexNameWithModes, Set.of());
    }

    public EsIndex(String name, Map<String, EsField> mapping) {
        this(name, mapping, Map.of(), Set.of());
    }

    public static EsIndex readFrom(StreamInput in) throws IOException {
        Map<String, IndexMode> indexNameWithModes;
        String name = in.readString();
        Map mapping = in.readImmutableMap(StreamInput::readString, EsField::readFrom);
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
            indexNameWithModes = in.readMap(IndexMode::readFrom);
        } else {
            Set indices = (Set)in.readGenericValue();
            assert (indices != null);
            indexNameWithModes = indices.stream().collect(Collectors.toMap(e -> e, e -> IndexMode.STANDARD));
        }
        return new EsIndex(name, mapping, indexNameWithModes, Set.of());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name());
        out.writeMap(this.mapping(), (o, x) -> x.writeTo(out));
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
            out.writeMap(this.indexNameWithModes, (o, v) -> IndexMode.writeTo((IndexMode)v, (StreamOutput)out));
        } else {
            out.writeGenericValue(this.indexNameWithModes.keySet());
        }
    }

    public boolean isPartiallyUnmappedField(String fieldName) {
        return this.partiallyUnmappedFields.contains(fieldName);
    }

    public Set<String> concreteIndices() {
        return this.indexNameWithModes.keySet();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

