/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.HashConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.HashEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Hash
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Hash", Hash::new);
    private final Expression algorithm;
    private final Expression input;
    private static final byte[] ASCII_HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    @FunctionInfo(returnType={"keyword"}, description="Computes the hash of the input using various algorithms such as MD5, SHA, SHA-224, SHA-256, SHA-384, SHA-512.", examples={@Example(file="hash", tag="hash")})
    public Hash(Source source, @Param(name="algorithm", type={"keyword", "text"}, description="Hash algorithm to use.") Expression algorithm, @Param(name="input", type={"keyword", "text"}, description="Input to hash.") Expression input) {
        super(source, List.of(algorithm, input));
        this.algorithm = algorithm;
        this.input = input;
    }

    private Hash(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.algorithm);
        out.writeNamedWriteable((NamedWriteable)this.input);
    }

    public String getWriteableName() {
        return Hash.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)this.algorithm, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isString((Expression)this.input, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
    }

    public boolean foldable() {
        return this.algorithm.foldable() && this.input.foldable();
    }

    static BytesRef process(BreakingBytesRefBuilder scratch, BytesRef algorithm, BytesRef input) throws NoSuchAlgorithmException {
        return Hash.hash(scratch, MessageDigest.getInstance(algorithm.utf8ToString()), input);
    }

    static BytesRef processConstant(BreakingBytesRefBuilder scratch, HashFunction algorithm, BytesRef input) {
        return Hash.hash(scratch, algorithm.digest, input);
    }

    private static BytesRef hash(BreakingBytesRefBuilder scratch, MessageDigest algorithm, BytesRef input) {
        algorithm.reset();
        algorithm.update(input.bytes, input.offset, input.length);
        byte[] digest = algorithm.digest();
        scratch.clear();
        scratch.grow(digest.length * 2);
        Hash.appendUtf8HexDigest(scratch, digest);
        return scratch.bytesRefView();
    }

    private static void appendUtf8HexDigest(BreakingBytesRefBuilder scratch, byte[] bytes) {
        for (byte b : bytes) {
            scratch.append(ASCII_HEX_BYTES[b >> 4 & 0xF]);
            scratch.append(ASCII_HEX_BYTES[b & 0xF]);
        }
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        if (this.algorithm.foldable()) {
            try {
                final HashFunction hf = HashFunction.create((BytesRef)this.algorithm.fold(toEvaluator.foldCtx()));
                return new HashConstantEvaluator.Factory(this.source(), context -> new BreakingBytesRefBuilder(context.breaker(), "hash"), new Function<DriverContext, HashFunction>(this){

                    @Override
                    public HashFunction apply(DriverContext context) {
                        return hf.copy();
                    }

                    public String toString() {
                        return hf.toString();
                    }
                }, toEvaluator.apply(this.input));
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidArgumentException((Throwable)e, "invalid algorithm for [{}]: {}", new Object[]{this.sourceText(), e.getMessage()});
            }
        }
        return new HashEvaluator.Factory(this.source(), context -> new BreakingBytesRefBuilder(context.breaker(), "hash"), toEvaluator.apply(this.algorithm), toEvaluator.apply(this.input));
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Hash(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Hash::new, (Object)((Expression)this.children().get(0)), (Object)((Expression)this.children().get(1)));
    }

    Expression algorithm() {
        return this.algorithm;
    }

    Expression input() {
        return this.input;
    }

    public record HashFunction(String algorithm, MessageDigest digest) {
        public static HashFunction create(String algorithm) {
            try {
                return new HashFunction(algorithm, MessageDigest.getInstance(algorithm));
            }
            catch (NoSuchAlgorithmException e) {
                assert (false) : "Expected to create a valid hashing algorithm";
                throw new IllegalStateException(e);
            }
        }

        public static HashFunction create(BytesRef literal) throws NoSuchAlgorithmException {
            String algorithm = literal.utf8ToString();
            return new HashFunction(algorithm, MessageDigest.getInstance(algorithm));
        }

        public HashFunction copy() {
            try {
                return new HashFunction(this.algorithm, MessageDigest.getInstance(this.algorithm));
            }
            catch (NoSuchAlgorithmException e) {
                assert (false) : "Algorithm should be valid at this point";
                throw new IllegalStateException(e);
            }
        }

        @Override
        public String toString() {
            return this.algorithm;
        }
    }
}

