/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.nulls;

import java.util.List;
import java.util.stream.IntStream;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;

abstract sealed class CoalesceLongEvaluator
implements EvalOperator.ExpressionEvaluator {
    protected final DriverContext driverContext;
    protected final List<EvalOperator.ExpressionEvaluator> evaluators;

    static EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator, List<Expression> children) {
        final List<EvalOperator.ExpressionEvaluator.Factory> childEvaluators = children.stream().map(toEvaluator::apply).toList();
        if (childEvaluators.stream().allMatch(EvalOperator.ExpressionEvaluator.Factory::eagerEvalSafeInLazy)) {
            return new EvalOperator.ExpressionEvaluator.Factory(){

                public EvalOperator.ExpressionEvaluator get(DriverContext context) {
                    return new CoalesceLongEagerEvaluator(context, childEvaluators.stream().map(x -> x.get(context)).toList());
                }

                public String toString() {
                    return "CoalesceLongEagerEvaluator[values=" + String.valueOf(childEvaluators) + "]";
                }
            };
        }
        return new EvalOperator.ExpressionEvaluator.Factory(){

            public EvalOperator.ExpressionEvaluator get(DriverContext context) {
                return new CoalesceLongLazyEvaluator(context, childEvaluators.stream().map(x -> x.get(context)).toList());
            }

            public String toString() {
                return "CoalesceLongLazyEvaluator[values=" + String.valueOf(childEvaluators) + "]";
            }
        };
    }

    protected CoalesceLongEvaluator(DriverContext driverContext, List<EvalOperator.ExpressionEvaluator> evaluators) {
        this.driverContext = driverContext;
        this.evaluators = evaluators;
    }

    public final LongBlock eval(Page page) {
        return this.entireBlock(page);
    }

    private LongBlock entireBlock(Page page) {
        LongBlock lastFullBlock;
        int lastFullBlockIdx = 0;
        while (true) {
            lastFullBlock = (LongBlock)this.evaluators.get(lastFullBlockIdx++).eval(page);
            if (lastFullBlockIdx == this.evaluators.size() || lastFullBlock.asVector() != null) {
                return lastFullBlock;
            }
            if (!lastFullBlock.areAllValuesNull()) break;
            lastFullBlock.close();
        }
        return this.perPosition(page, lastFullBlock, lastFullBlockIdx);
    }

    protected abstract LongBlock perPosition(Page var1, LongBlock var2, int var3);

    public final String toString() {
        return this.getClass().getSimpleName() + "[values=" + String.valueOf(this.evaluators) + "]";
    }

    public final void close() {
        Releasables.closeExpectNoException(() -> Releasables.close(this.evaluators));
    }

    static final class CoalesceLongLazyEvaluator
    extends CoalesceLongEvaluator {
        CoalesceLongLazyEvaluator(DriverContext driverContext, List<EvalOperator.ExpressionEvaluator> evaluators) {
            super(driverContext, evaluators);
        }

        @Override
        protected LongBlock perPosition(Page page, LongBlock lastFullBlock, int firstToEvaluate) {
            int positionCount = page.getPositionCount();
            try {
                LongBlock longBlock;
                block25: {
                    LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);
                    try {
                        block19: for (int p = 0; p < positionCount; ++p) {
                            if (!lastFullBlock.isNull(p)) {
                                result.copyFrom(lastFullBlock, p, p + 1);
                                continue;
                            }
                            int[] positions = new int[]{p};
                            Page limited = new Page(1, (Block[])IntStream.range(0, page.getBlockCount()).mapToObj(b -> page.getBlock(b).filter(positions)).toArray(Block[]::new));
                            try (Releasable ignored = () -> ((Page)limited).releaseBlocks();){
                                for (int e = firstToEvaluate; e < this.evaluators.size(); ++e) {
                                    try (LongBlock block = (LongBlock)((EvalOperator.ExpressionEvaluator)this.evaluators.get(e)).eval(limited);){
                                        if (block.isNull(0)) continue;
                                        result.copyFrom(block, 0);
                                        continue block19;
                                    }
                                }
                                result.appendNull();
                                continue;
                            }
                        }
                        longBlock = result.build();
                        if (result == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return longBlock;
            }
            finally {
                lastFullBlock.close();
            }
        }
    }

    static final class CoalesceLongEagerEvaluator
    extends CoalesceLongEvaluator {
        CoalesceLongEagerEvaluator(DriverContext driverContext, List<EvalOperator.ExpressionEvaluator> evaluators) {
            super(driverContext, evaluators);
        }

        @Override
        protected LongBlock perPosition(Page page, LongBlock lastFullBlock, int firstToEvaluate) {
            int positionCount = page.getPositionCount();
            LongBlock[] flatten = new LongBlock[this.evaluators.size() - firstToEvaluate + 1];
            try {
                LongBlock longBlock;
                block12: {
                    flatten[0] = lastFullBlock;
                    for (int f = 1; f < flatten.length; ++f) {
                        flatten[f] = (LongBlock)((EvalOperator.ExpressionEvaluator)this.evaluators.get(firstToEvaluate + f - 1)).eval(page);
                    }
                    LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);
                    try {
                        block9: for (int p = 0; p < positionCount; ++p) {
                            for (LongBlock f : flatten) {
                                if (f.isNull(p)) continue;
                                result.copyFrom(f, p);
                                continue block9;
                            }
                            result.appendNull();
                        }
                        longBlock = result.build();
                        if (result == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return longBlock;
            }
            finally {
                Releasables.close((Releasable[])flatten);
            }
        }
    }
}

