/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.util.Arrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Greatest;

public final class GreatestLongEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator[] values;
    private final DriverContext driverContext;
    private Warnings warnings;

    public GreatestLongEvaluator(Source source, EvalOperator.ExpressionEvaluator[] values, DriverContext driverContext) {
        this.source = source;
        this.values = values;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        LongBlock[] valuesBlocks = new LongBlock[this.values.length];
        try (Releasable valuesRelease = Releasables.wrap((Releasable[])valuesBlocks);){
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesBlocks[i] = (LongBlock)this.values[i].eval(page);
            }
            LongVector[] valuesVectors = new LongVector[this.values.length];
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesVectors[i] = valuesBlocks[i].asVector();
                if (valuesVectors[i] != null) continue;
                LongBlock longBlock = this.eval(page.getPositionCount(), valuesBlocks);
                return longBlock;
            }
            LongBlock longBlock = this.eval(page.getPositionCount(), valuesVectors).asBlock();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongBlock[] valuesBlocks) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            long[] valuesValues = new long[this.values.length];
            block5: for (int p = 0; p < positionCount; ++p) {
                int i;
                for (i = 0; i < valuesBlocks.length; ++i) {
                    if (valuesBlocks[i].isNull(p)) {
                        result.appendNull();
                        continue block5;
                    }
                    if (valuesBlocks[i].getValueCount(p) == 1) continue;
                    if (valuesBlocks[i].getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue block5;
                }
                for (i = 0; i < valuesBlocks.length; ++i) {
                    int o = valuesBlocks[i].getFirstValueIndex(p);
                    valuesValues[i] = valuesBlocks[i].getLong(o);
                }
                result.appendLong(Greatest.process(valuesValues));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, LongVector[] valuesVectors) {
        try (LongVector.FixedBuilder result = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            long[] valuesValues = new long[this.values.length];
            for (int p = 0; p < positionCount; ++p) {
                for (int i = 0; i < valuesVectors.length; ++i) {
                    valuesValues[i] = valuesVectors[i].getLong(p);
                }
                result.appendLong(p, Greatest.process(valuesValues));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "GreatestLongEvaluator[values=" + Arrays.toString(this.values) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException(() -> Releasables.close((Releasable[])this.values));
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory[] values;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory[] values) {
            this.source = source;
            this.values = values;
        }

        public GreatestLongEvaluator get(DriverContext context) {
            EvalOperator.ExpressionEvaluator[] values = (EvalOperator.ExpressionEvaluator[])Arrays.stream(this.values).map(a -> a.get(context)).toArray(EvalOperator.ExpressionEvaluator[]::new);
            return new GreatestLongEvaluator(this.source, values, context);
        }

        public String toString() {
            return "GreatestLongEvaluator[values=" + Arrays.toString(this.values) + "]";
        }
    }
}

