/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;

public class NamedExpressions {
    public static List<Attribute> mergeOutputAttributes(List<? extends NamedExpression> fields, List<? extends NamedExpression> childOutput) {
        return Expressions.asAttributes(NamedExpressions.mergeOutputExpressions(fields, childOutput));
    }

    public static List<NamedExpression> mergeOutputExpressions(List<? extends NamedExpression> fields, List<? extends NamedExpression> childOutput) {
        Map lastPositions = Maps.newHashMapWithExpectedSize((int)fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            lastPositions.put(fields.get(i).name(), i);
        }
        ArrayList<NamedExpression> output = new ArrayList<NamedExpression>(childOutput.size() + fields.size());
        for (NamedExpression namedExpression : childOutput) {
            if (lastPositions.containsKey(namedExpression.name())) continue;
            output.add(namedExpression);
        }
        for (int i = 0; i < fields.size(); ++i) {
            NamedExpression namedExpression = fields.get(i);
            if ((Integer)lastPositions.get(namedExpression.name()) != i) continue;
            output.add(namedExpression);
        }
        return output;
    }
}

