/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.Max;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.aggregations.support.HistogramValuesSource;

public final class HistoBackedMaxAggregator
extends NumericMetricsAggregator.SingleValue {
    private final HistogramValuesSource.Histogram valuesSource;
    final DocValueFormat formatter;
    DoubleArray maxes;

    public HistoBackedMaxAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (config.hasValues());
        this.valuesSource = (HistogramValuesSource.Histogram)config.getValuesSource();
        this.maxes = this.bigArrays().newDoubleArray(1L, false);
        this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
        this.formatter = config.format();
    }

    public ScoreMode scoreMode() {
        return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final HistogramValues values = this.valuesSource.getHistogramValues(aggCtx.getLeafReaderContext());
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= HistoBackedMaxAggregator.this.maxes.size()) {
                    long from = HistoBackedMaxAggregator.this.maxes.size();
                    HistoBackedMaxAggregator.this.maxes = HistoBackedMaxAggregator.this.bigArrays().grow(HistoBackedMaxAggregator.this.maxes, bucket + 1L);
                    HistoBackedMaxAggregator.this.maxes.fill(from, HistoBackedMaxAggregator.this.maxes.size(), Double.NEGATIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    HistogramValue sketch = values.histogram();
                    while (sketch.next()) {
                        double value = sketch.value();
                        double max = HistoBackedMaxAggregator.this.maxes.get(bucket);
                        max = Math.max(max, value);
                        HistoBackedMaxAggregator.this.maxes.set(bucket, max);
                    }
                }
            }
        };
    }

    public double metric(long owningBucketOrd) {
        if (owningBucketOrd >= this.maxes.size()) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.maxes.get(owningBucketOrd);
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.maxes.size()) {
            return this.buildEmptyAggregation();
        }
        return new Max(this.name, this.maxes.get(bucket), this.formatter, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return Max.createEmptyMax((String)this.name, (DocValueFormat)this.formatter, (Map)this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable)this.maxes);
    }
}

