/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.monitor.metrics.IndexModeStatsActionType;
import org.elasticsearch.monitor.metrics.IndexStats;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.application.LogsDBFeatureSetUsage;
import org.elasticsearch.xpack.logsdb.LogsDBPlugin;

public class LogsDBUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final ClusterService clusterService;
    private final Client client;

    @Inject
    public LogsDBUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super(XPackUsageFeatureAction.LOGSDB.name(), transportService, clusterService, threadPool, actionFilters);
        this.clusterService = clusterService;
        this.client = client;
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        int numIndices = 0;
        int numIndicesWithSyntheticSources = 0;
        for (IndexMetadata indexMetadata : state.metadata()) {
            if (indexMetadata.getIndexMode() != IndexMode.LOGSDB) continue;
            ++numIndices;
            if (IndexSettings.INDEX_MAPPER_SOURCE_MODE_SETTING.get(indexMetadata.getSettings()) != SourceFieldMapper.Mode.SYNTHETIC) continue;
            ++numIndicesWithSyntheticSources;
        }
        boolean enabled = (Boolean)LogsDBPlugin.CLUSTER_LOGSDB_ENABLED.get(this.clusterService.getSettings());
        boolean hasCustomCutoffDate = System.getProperty("es.mapping.synthetic_source_fallback_to_stored_source.cutoff_date_restricted_override") != null;
        DiscoveryNode[] nodes = (DiscoveryNode[])state.nodes().getDataNodes().values().toArray(DiscoveryNode[]::new);
        IndexModeStatsActionType.StatsRequest statsRequest = new IndexModeStatsActionType.StatsRequest(nodes);
        int finalNumIndices = numIndices;
        int finalNumIndicesWithSyntheticSources = numIndicesWithSyntheticSources;
        this.client.execute((ActionType)IndexModeStatsActionType.TYPE, (ActionRequest)statsRequest, listener.map(statsResponse -> {
            IndexStats indexStats = (IndexStats)statsResponse.stats().get(IndexMode.LOGSDB);
            return new XPackUsageFeatureResponse((XPackFeatureUsage)new LogsDBFeatureSetUsage(true, enabled, finalNumIndices, finalNumIndicesWithSyntheticSources, indexStats.numDocs(), indexStats.numBytes(), hasCustomCutoffDate));
        }));
    }
}

