/*
 * Decompiled with CFR 0.152.
 */
package com.wdtinc.mapbox_vector_tile.adapt.jts;

import com.wdtinc.mapbox_vector_tile.VectorTile;
import com.wdtinc.mapbox_vector_tile.adapt.jts.IUserDataConverter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.JtsAdapter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.UserDataKeyValueMapConverter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.model.JtsLayer;
import com.wdtinc.mapbox_vector_tile.adapt.jts.model.JtsMvt;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerBuild;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerParams;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerProps;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;

public final class MvtEncoder {
    public static byte[] encode(JtsMvt mvt) {
        return MvtEncoder.encode(mvt, MvtLayerParams.DEFAULT, new UserDataKeyValueMapConverter());
    }

    public static byte[] encode(JtsMvt mvt, MvtLayerParams mvtLayerParams, IUserDataConverter userDataConverter) {
        VectorTile.Tile.Builder tileBuilder = VectorTile.Tile.newBuilder();
        for (JtsLayer layer : mvt.getLayers()) {
            Collection<Geometry> layerGeoms = layer.getGeometries();
            VectorTile.Tile.Layer.Builder layerBuilder = MvtLayerBuild.newLayerBuilder(layer.getName(), mvtLayerParams);
            MvtLayerProps layerProps = new MvtLayerProps();
            List<VectorTile.Tile.Feature> features = JtsAdapter.toFeatures(layerGeoms, layerProps, userDataConverter);
            layerBuilder.addAllFeatures(features);
            MvtLayerBuild.writeProps(layerBuilder, layerProps);
            VectorTile.Tile.Layer vtl = layerBuilder.build();
            tileBuilder.addLayers(vtl);
        }
        return tileBuilder.build().toByteArray();
    }
}

