/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.rollup.RollupFeatureSetUsage;

public class RollupUsageTransportAction
extends XPackUsageFeatureTransportAction {
    @Inject
    public RollupUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
        super(XPackUsageFeatureAction.ROLLUP.name(), transportService, clusterService, threadPool, actionFilters);
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        int numberOfRollupJobs = RollupUsageTransportAction.findNumberOfRollupJobs(state);
        RollupFeatureSetUsage usage = new RollupFeatureSetUsage(numberOfRollupJobs);
        listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureUsage)usage));
    }

    static int findNumberOfRollupJobs(ClusterState state) {
        int numberOfRollupJobs = 0;
        PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
        if (persistentTasks != null) {
            numberOfRollupJobs = persistentTasks.findTasks("xpack/rollup/job", Predicates.always()).size();
        }
        return numberOfRollupJobs;
    }
}

