/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.kql.parser;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.kql.parser.KqlAstBuilder;
import org.elasticsearch.xpack.kql.parser.KqlBaseLexer;
import org.elasticsearch.xpack.kql.parser.KqlBaseParser;
import org.elasticsearch.xpack.kql.parser.KqlParsingContext;
import org.elasticsearch.xpack.kql.parser.KqlParsingException;

public class KqlParser {
    private static final Logger log = LogManager.getLogger(KqlParser.class);
    private static final BaseErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new KqlParsingException(message, line, charPositionInLine, e);
        }
    };

    public QueryBuilder parseKqlQuery(String kqlQuery, KqlParsingContext kqlParserContext) {
        log.trace("Parsing KQL query: {}", new Object[]{kqlQuery});
        return this.invokeParser(kqlQuery, kqlParserContext, KqlBaseParser::topLevelQuery, KqlAstBuilder::toQueryBuilder);
    }

    private <T> T invokeParser(String kqlQuery, KqlParsingContext kqlParsingContext, Function<KqlBaseParser, ParserRuleContext> parseFunction, BiFunction<KqlAstBuilder, ParserRuleContext, T> visitor) {
        KqlBaseLexer lexer = new KqlBaseLexer((CharStream)CharStreams.fromString((String)kqlQuery));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        KqlBaseParser parser = new KqlBaseParser((TokenStream)tokenStream);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        ParserRuleContext tree = parseFunction.apply(parser);
        log.trace(() -> Strings.format((String)"Parse tree: %s", (Object[])new Object[]{tree.toStringTree()}));
        return visitor.apply(new KqlAstBuilder(kqlParsingContext), tree);
    }
}

