/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import java.io.File;
import java.util.Comparator;
import org.elasticsearch.core.SuppressForbidden;

public class FileUtils {
    static final Comparator<String> PATH_ORDER = (s1, s2) -> {
        int len1 = s1.length();
        int len2 = s2.length();
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = s1.charAt(k);
            if (c1 == (c2 = s2.charAt(k))) continue;
            boolean c1IsSeparator = FileUtils.isPathSeparator(c1);
            boolean c2IsSeparator = FileUtils.isPathSeparator(c2);
            if (c1IsSeparator && c2IsSeparator) continue;
            if (c1IsSeparator) {
                return -1;
            }
            if (c2IsSeparator) {
                return 1;
            }
            return c1 - c2;
        }
        return len1 - len2;
    };

    private FileUtils() {
    }

    @SuppressForbidden(reason="we need the separator as a char, not a string")
    private static boolean isPathSeparator(char c) {
        return c == File.separatorChar;
    }

    public static boolean isAbsolutePath(String path) {
        if (path.isEmpty()) {
            return false;
        }
        if (path.charAt(0) == '/') {
            return true;
        }
        return FileUtils.isWindowsAbsolutePath(path);
    }

    static boolean isSlash(char c) {
        return c == '\\' || c == '/';
    }

    private static boolean isWindowsAbsolutePath(String input) {
        if (input.startsWith("\\\\?\\")) {
            return true;
        }
        if (input.length() > 1) {
            char c0 = input.charAt(0);
            char c1 = input.charAt(1);
            if (FileUtils.isSlash(c0) && FileUtils.isSlash(c1)) {
                return true;
            }
            if (Character.isLetter(c0) && c1 == ':') {
                return true;
            }
        }
        return false;
    }
}

