/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series.primitive;

import org.ojalgo.array.Array1D;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.series.primitive.AccessSeries;
import org.ojalgo.series.primitive.BinaryFunctionSeries;
import org.ojalgo.series.primitive.DataSeries;
import org.ojalgo.series.primitive.DifferencesSeries;
import org.ojalgo.series.primitive.PrunedSeries;
import org.ojalgo.series.primitive.QuotientsSeries;
import org.ojalgo.series.primitive.UnaryFunctionSeries;
import org.ojalgo.structure.Access1D;

public abstract class PrimitiveSeries
implements Access1D<Double> {
    public static PrimitiveSeries copy(Access1D<?> template) {
        return new AccessSeries((Access1D<?>)Array1D.PRIMITIVE64.copy((Access1D)template));
    }

    public static PrimitiveSeries wrap(Access1D<?> base) {
        return new AccessSeries(base);
    }

    protected PrimitiveSeries() {
    }

    public PrimitiveSeries add(double addend) {
        return new UnaryFunctionSeries(this, PrimitiveMath.ADD.second(addend));
    }

    public PrimitiveSeries add(PrimitiveSeries addend) {
        return new BinaryFunctionSeries(this, PrimitiveMath.ADD, addend);
    }

    public PrimitiveSeries copy() {
        return this.toDataSeries();
    }

    @Override
    public long count() {
        return this.size();
    }

    public PrimitiveSeries differences() {
        return new DifferencesSeries(this, 1);
    }

    public PrimitiveSeries differences(int period) {
        return new DifferencesSeries(this, period);
    }

    public PrimitiveSeries divide(double divisor) {
        return new UnaryFunctionSeries(this, PrimitiveMath.DIVIDE.second(divisor));
    }

    public PrimitiveSeries divide(PrimitiveSeries divisor) {
        return new BinaryFunctionSeries(this, PrimitiveMath.DIVIDE, divisor);
    }

    @Override
    public final double doubleValue(long index) {
        return this.value((int)index);
    }

    public PrimitiveSeries exp() {
        return new UnaryFunctionSeries(this, PrimitiveMath.EXP);
    }

    public final Double get(int index) {
        return this.value(index);
    }

    @Override
    public final Double get(long index) {
        return this.value((int)index);
    }

    public PrimitiveSeries log() {
        return new UnaryFunctionSeries(this, PrimitiveMath.LOG);
    }

    public PrimitiveSeries multiply(double multiplicand) {
        return new UnaryFunctionSeries(this, PrimitiveMath.MULTIPLY.second(multiplicand));
    }

    public PrimitiveSeries multiply(PrimitiveSeries multiplicand) {
        return new BinaryFunctionSeries(this, PrimitiveMath.MULTIPLY, multiplicand);
    }

    public PrimitiveSeries prune(int shift) {
        return new PrunedSeries(this, shift);
    }

    public PrimitiveSeries quotients() {
        return new QuotientsSeries(this, 1);
    }

    public PrimitiveSeries quotients(int period) {
        return new QuotientsSeries(this, period);
    }

    public PrimitiveSeries runningProduct(double initialValue) {
        int tmpNewSize = this.size() + 1;
        double[] tmpValues = new double[tmpNewSize];
        double tmpAggrVal = tmpValues[0] = initialValue;
        for (int i = 1; i < tmpNewSize; ++i) {
            tmpValues[i] = tmpAggrVal *= this.value(i - 1);
        }
        return DataSeries.wrap(tmpValues);
    }

    public PrimitiveSeries runningSum(double initialValue) {
        int tmpNewSize = this.size() + 1;
        double[] tmpValues = new double[tmpNewSize];
        double tmpAggrVal = tmpValues[0] = initialValue;
        for (int i = 1; i < tmpNewSize; ++i) {
            tmpValues[i] = tmpAggrVal += this.value(i - 1);
        }
        return DataSeries.wrap(tmpValues);
    }

    @Override
    public abstract int size();

    public PrimitiveSeries subtract(double subtrahend) {
        return new UnaryFunctionSeries(this, PrimitiveMath.SUBTRACT.second(subtrahend));
    }

    public PrimitiveSeries subtract(PrimitiveSeries subtrahend) {
        return new BinaryFunctionSeries(this, PrimitiveMath.SUBTRACT, subtrahend);
    }

    public final DataSeries toDataSeries() {
        return DataSeries.wrap(this.values());
    }

    public final String toString() {
        return Access1D.toString(this);
    }

    public abstract double value(int var1);

    public final double[] values() {
        int tmpSize = this.size();
        double[] retVal = new double[tmpSize];
        for (int i = 0; i < tmpSize; ++i) {
            retVal[i] = this.value(i);
        }
        return retVal;
    }
}

