/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.util.function.IntPredicate;

public abstract class ASCII {
    public static final char COMMA = ',';
    public static final char CR = '\r';
    public static final char DECIMAL_NINE = '9';
    public static final char DECIMAL_ZERO = '0';
    public static final char DEL = '\u007f';
    public static final char EQUALS = '=';
    public static final char HT = '\t';
    public static final char LCB = '{';
    public static final char LF = '\n';
    public static final char LOWERCASE_A = 'a';
    public static final char LOWERCASE_Z = 'z';
    public static final char NBSP = '\u00a0';
    public static final char NULL = '\u0000';
    public static final char RCB = '}';
    public static final char SEMICOLON = ';';
    public static final char SP = ' ';
    public static final char UNDERSCORE = '_';
    public static final char UPPERCASE_A = 'A';
    public static final char UPPERCASE_Z = 'Z';

    public static String generateRandom(int length, IntPredicate predicate) {
        StringBuilder builder = new StringBuilder();
        int soFar = 0;
        while (soFar < length) {
            int maybe = (int)(Double.doubleToRawLongBits(Math.random()) % 128L);
            if (!predicate.test(maybe)) continue;
            builder.append((char)maybe);
            ++soFar;
        }
        return builder.toString();
    }

    public static boolean isAlphabetic(int aChar) {
        return ASCII.isLowercase(aChar) || ASCII.isUppercase(aChar);
    }

    public static boolean isAlphanumeric(int aChar) {
        return ASCII.isAlphabetic(aChar) || ASCII.isDigit(aChar);
    }

    public static boolean isAscii(int aChar) {
        return 0 <= aChar && aChar <= 127;
    }

    public static boolean isControl(int aChar) {
        return 0 <= aChar && aChar < 32 || aChar == 127;
    }

    public static boolean isDigit(int aChar) {
        return 48 <= aChar && aChar <= 57;
    }

    public static boolean isGraph(int aChar) {
        return 32 < aChar && aChar < 127;
    }

    public static boolean isLowercase(int aChar) {
        return 97 <= aChar && aChar <= 122;
    }

    public static boolean isPrintable(int aChar) {
        return 32 <= aChar && aChar < 127;
    }

    public static boolean isPunctuation(int aChar) {
        return ASCII.isGraph(aChar) && !ASCII.isAlphanumeric(aChar);
    }

    public static boolean isSpace(int aChar) {
        return aChar == 32 || 9 <= aChar && aChar <= 13;
    }

    public static boolean isUppercase(int aChar) {
        return 65 <= aChar && aChar <= 90;
    }

    public static int toLowercase(int aChar) {
        return ASCII.isUppercase(aChar) ? aChar + 32 : aChar;
    }

    public static int toPrintable(int aChar) {
        return ASCII.isPrintable(aChar) ? aChar : 32;
    }

    public static int toUppercase(int aChar) {
        return ASCII.isLowercase(aChar) ? aChar - 32 : aChar;
    }

    private ASCII() {
    }
}

