/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.array.DenseArray;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;

abstract class PrimitiveFactory<I extends PhysicalStore<Double>>
implements PhysicalStore.Factory<Double, I> {
    PrimitiveFactory() {
    }

    @Override
    public final AggregatorSet<Double> aggregator() {
        return PrimitiveAggregator.getSet();
    }

    @Override
    public DenseArray.Factory<Double> array() {
        return Primitive64Array.FACTORY;
    }

    @Override
    public final I conjugate(Access2D<?> source) {
        return this.transpose(source);
    }

    @Override
    public final FunctionSet<Double> function() {
        return PrimitiveFunction.getSet();
    }

    @Override
    public Householder<Double> makeHouseholder(int length) {
        return new Householder.Primitive64(length);
    }

    public final Rotation.Primitive makeRotation(int low, int high, double cos, double sin) {
        return new Rotation.Primitive(low, high, cos, sin);
    }

    public final Rotation.Primitive makeRotation(int low, int high, Double cos, Double sin) {
        return this.makeRotation(low, high, cos != null ? cos : Double.NaN, sin != null ? sin : Double.NaN);
    }

    @Override
    public final Scalar.Factory<Double> scalar() {
        return PrimitiveScalar.FACTORY;
    }
}

