/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import java.math.BigDecimal;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Structure2D;

public final class AMAX
implements ArrayOperation {
    public static int THRESHOLD = 128;

    public static long invoke(Access1D<?> data, long first, long limit, long step) {
        long retVal = first;
        double largest = 0.0;
        for (long i = first; i < limit; i += step) {
            double candidate = Math.abs(data.doubleValue(i));
            if (!(candidate > largest)) continue;
            largest = candidate;
            retVal = i;
        }
        return retVal;
    }

    public static int invoke(BigDecimal[] data, int first, int limit, int step) {
        int retVal = first;
        BigDecimal largest = BigMath.ZERO;
        for (int i = first; i < limit; i += step) {
            BigDecimal candidate = data[i].abs();
            if (candidate.compareTo(largest) <= 0) continue;
            largest = candidate;
            retVal = i;
        }
        return retVal;
    }

    public static int invoke(double[] data, int first, int limit, int step) {
        int retVal = first;
        double largest = 0.0;
        for (int i = first; i < limit; i += step) {
            double candidate = Math.abs(data[i]);
            if (!(candidate > largest)) continue;
            largest = candidate;
            retVal = i;
        }
        return retVal;
    }

    public static long invoke(double[][] data) {
        int nbRows = data.length;
        int nbCols = nbRows != 0 ? data[0].length : 0;
        long retVal = 0L;
        double largest = PrimitiveMath.ZERO;
        for (int i = 0; i < nbRows; ++i) {
            double[] tmpRow = data[i];
            for (int j = 0; j < nbCols; ++j) {
                double candidate = Math.abs(tmpRow[j]);
                if (!(candidate > largest)) continue;
                largest = candidate;
                retVal = Structure2D.index(nbRows, i, j);
            }
        }
        return retVal;
    }

    public static int invoke(float[] data, int first, int limit, int step) {
        int retVal = first;
        float largest = 0.0f;
        for (int i = first; i < limit; i += step) {
            float candidate = Math.abs(data[i]);
            if (!(candidate > largest)) continue;
            largest = candidate;
            retVal = i;
        }
        return retVal;
    }

    public static <N extends Scalar<N>> int invoke(N[] data, int first, int limit, int step) {
        int retVal = first;
        double largest = 0.0;
        for (int i = first; i < limit; i += step) {
            double candidate = data[i].norm();
            if (!(candidate > largest)) continue;
            largest = candidate;
            retVal = i;
        }
        return retVal;
    }

    public static int invoke(PlainArray<?> data, int first, int limit, int step) {
        int retVal = first;
        double largest = 0.0;
        for (int i = first; i < limit; i += step) {
            double candidate = Math.abs(data.doubleValue((long)i));
            if (!(candidate > largest)) continue;
            largest = candidate;
            retVal = i;
        }
        return retVal;
    }
}

