/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.util;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class Queries {
    public static QueryBuilder combine(Clause clause, List<QueryBuilder> queries) {
        QueryBuilder firstQuery = null;
        QueryBuilder bool = null;
        for (QueryBuilder query : queries) {
            if (query == null) continue;
            if (firstQuery == null) {
                firstQuery = query;
                if (!(firstQuery instanceof BoolQueryBuilder)) continue;
                BoolQueryBuilder bqb = (BoolQueryBuilder)firstQuery;
                bool = bqb.shallowCopy();
                continue;
            }
            if (bool == null) {
                bool = Queries.combine(clause, QueryBuilders.boolQuery(), firstQuery);
            }
            bool = Queries.combine(clause, (BoolQueryBuilder)bool, query);
        }
        return bool == null ? firstQuery : bool;
    }

    private static BoolQueryBuilder combine(Clause clause, BoolQueryBuilder bool, QueryBuilder query) {
        List<QueryBuilder> list = clause.innerQueries.apply(bool);
        if (!list.contains(query)) {
            list.add(query);
        }
        return bool;
    }

    public static enum Clause {
        FILTER(BoolQueryBuilder::filter),
        MUST(BoolQueryBuilder::must),
        MUST_NOT(BoolQueryBuilder::mustNot),
        SHOULD(BoolQueryBuilder::should);

        final Function<BoolQueryBuilder, List<QueryBuilder>> innerQueries;

        private Clause(Function<BoolQueryBuilder, List<QueryBuilder>> innerQueries) {
            this.innerQueries = innerQueries;
        }
    }
}

