/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.querydsl.query;

import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class PrefixQuery
extends Query {
    private final String field;
    private final String query;
    private final boolean caseInsensitive;

    public PrefixQuery(Source source, String field, String query, boolean caseInsensitive) {
        super(source);
        this.field = field;
        this.query = query;
        this.caseInsensitive = caseInsensitive;
    }

    public String field() {
        return this.field;
    }

    public String query() {
        return this.query;
    }

    @Override
    protected QueryBuilder asBuilder() {
        return QueryBuilders.prefixQuery((String)this.field, (String)this.query).caseInsensitive(this.caseInsensitive);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.query, this.caseInsensitive);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrefixQuery other = (PrefixQuery)obj;
        return this.caseInsensitive == other.caseInsensitive && Objects.equals(this.field, other.field) && Objects.equals(this.query, other.query);
    }

    @Override
    protected String innerToString() {
        return this.field + ":" + this.query;
    }
}

