/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison;

import java.util.function.BiFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.PredicateBiFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.Comparisons;

public enum BinaryComparisonOperation implements PredicateBiFunction<Object, Object, Boolean>
{
    EQ(Comparisons::eq, "=="),
    NULLEQ(Comparisons::nulleq, "<=>"),
    NEQ(Comparisons::neq, "!="),
    GT(Comparisons::gt, ">"),
    GTE(Comparisons::gte, ">="),
    LT(Comparisons::lt, "<"),
    LTE(Comparisons::lte, "<=");

    private final BiFunction<Object, Object, Boolean> process;
    private final String symbol;

    private BinaryComparisonOperation(BiFunction<Object, Object, Boolean> process, String symbol) {
        this.process = process;
        this.symbol = symbol;
    }

    @Override
    public String symbol() {
        return this.symbol;
    }

    @Override
    public Boolean apply(Object left, Object right) {
        if (this != NULLEQ && (left == null || right == null)) {
            return null;
        }
        return this.doApply(left, right);
    }

    @Override
    public final Boolean doApply(Object left, Object right) {
        return this.process.apply(left, right);
    }

    public String toString() {
        return this.symbol;
    }
}

