/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.EntryExpression;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;

public class ExpressionCoreWritables {
    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.addAll(ExpressionCoreWritables.expressions());
        entries.addAll(ExpressionCoreWritables.namedExpressions());
        entries.addAll(ExpressionCoreWritables.attributes());
        return entries;
    }

    public static List<NamedWriteableRegistry.Entry> expressions() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        for (NamedWriteableRegistry.Entry e : ExpressionCoreWritables.namedExpressions()) {
            entries.add(new NamedWriteableRegistry.Entry(Expression.class, e.name, in -> (Expression)e.reader.read(in)));
        }
        entries.add(Literal.ENTRY);
        entries.addAll(ExpressionCoreWritables.mapExpressions());
        return entries;
    }

    public static List<NamedWriteableRegistry.Entry> namedExpressions() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        for (NamedWriteableRegistry.Entry e : ExpressionCoreWritables.attributes()) {
            entries.add(new NamedWriteableRegistry.Entry(NamedExpression.class, e.name, in -> (NamedExpression)e.reader.read(in)));
        }
        entries.add(Alias.ENTRY);
        return entries;
    }

    public static List<NamedWriteableRegistry.Entry> attributes() {
        return List.of(FieldAttribute.ENTRY, MetadataAttribute.ENTRY, ReferenceAttribute.ENTRY);
    }

    public static List<NamedWriteableRegistry.Entry> mapExpressions() {
        return List.of(EntryExpression.ENTRY, MapExpression.ENTRY);
    }
}

