/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rest;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.inference.action.PutInferenceModelAction;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutInferenceModelAction
extends BaseRestHandler {
    public String getName() {
        return "put_inference_model_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "_inference/{task_type_or_id}"), new RestHandler.Route(RestRequest.Method.PUT, "_inference/{task_type_or_id}/{inference_id}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        TaskType taskType;
        String inferenceEntityId;
        if (restRequest.hasParam("inference_id")) {
            inferenceEntityId = restRequest.param("inference_id");
            taskType = TaskType.fromStringOrStatusException((String)restRequest.param("task_type_or_id"));
        } else {
            inferenceEntityId = restRequest.param("task_type_or_id");
            taskType = TaskType.ANY;
        }
        ReleasableBytesReference content = restRequest.requiredContent();
        PutInferenceModelAction.Request request = new PutInferenceModelAction.Request(taskType, inferenceEntityId, (BytesReference)content, restRequest.getXContentType());
        return channel -> client.execute((ActionType)PutInferenceModelAction.INSTANCE, (ActionRequest)request, ActionListener.withRef((ActionListener)new RestToXContentListener(channel), (RefCounted)content));
    }
}

