/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.elasticsearch.xpack.inference.mapper.OffsetSourceFieldMapper;

public final class OffsetSourceField
extends Field {
    private static final FieldType FIELD_TYPE = new FieldType();
    private int startOffset;
    private int endOffset;

    public OffsetSourceField(String fieldName, String sourceFieldName, int startOffset, int endOffset) {
        super(fieldName, (CharSequence)sourceFieldName, (IndexableFieldType)FIELD_TYPE);
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public void setValues(String fieldName, int startOffset, int endOffset) {
        this.fieldsData = fieldName;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
        OffsetTokenStream stream = reuse instanceof OffsetTokenStream ? (OffsetTokenStream)reuse : new OffsetTokenStream();
        stream.setValues((String)this.fieldsData, this.startOffset, this.endOffset);
        return stream;
    }

    public static OffsetSourceLoader loader(Terms terms) throws IOException {
        return new OffsetSourceLoader(terms);
    }

    static {
        FIELD_TYPE.setTokenized(false);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
    }

    private static final class OffsetTokenStream
    extends TokenStream {
        private final CharTermAttribute termAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAttribute = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        private boolean used = true;
        private String term = null;
        private int startOffset = 0;
        private int endOffset = 0;

        private OffsetTokenStream() {
        }

        void setValues(String term, int startOffset, int endOffset) {
            this.term = term;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public boolean incrementToken() {
            if (this.used) {
                return false;
            }
            this.clearAttributes();
            this.termAttribute.append(this.term);
            this.offsetAttribute.setOffset(this.startOffset, this.endOffset);
            this.used = true;
            return true;
        }

        public void reset() {
            this.used = false;
        }

        public void close() {
            this.term = null;
        }
    }

    public static class OffsetSourceLoader {
        private final Map<String, PostingsEnum> postingsEnums = new LinkedHashMap<String, PostingsEnum>();

        private OffsetSourceLoader(Terms terms) throws IOException {
            TermsEnum termsEnum = terms.iterator();
            while (termsEnum.next() != null) {
                PostingsEnum postings = termsEnum.postings(null, 56);
                if (postings.nextDoc() == Integer.MAX_VALUE) continue;
                this.postingsEnums.put(termsEnum.term().utf8ToString(), postings);
            }
        }

        public OffsetSourceFieldMapper.OffsetSource advanceTo(int doc) throws IOException {
            Iterator<Map.Entry<String, PostingsEnum>> it = this.postingsEnums.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, PostingsEnum> entry = it.next();
                PostingsEnum postings = entry.getValue();
                if (postings.docID() < doc && postings.advance(doc) == Integer.MAX_VALUE) {
                    it.remove();
                    continue;
                }
                if (postings.docID() != doc) continue;
                assert (postings.freq() == 1);
                postings.nextPosition();
                return new OffsetSourceFieldMapper.OffsetSource(entry.getKey(), postings.startOffset(), postings.endOffset());
            }
            return null;
        }
    }
}

