/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.cohere.completion;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.inference.external.cohere.CohereAccount;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.cohere.CohereRequest;
import org.elasticsearch.xpack.inference.external.request.cohere.completion.CohereCompletionRequestEntity;
import org.elasticsearch.xpack.inference.services.cohere.completion.CohereCompletionModel;

public class CohereCompletionRequest
extends CohereRequest {
    private final CohereAccount account;
    private final List<String> input;
    private final String modelId;
    private final String inferenceEntityId;
    private final boolean stream;

    public CohereCompletionRequest(List<String> input, CohereCompletionModel model, boolean stream) {
        Objects.requireNonNull(model);
        this.account = CohereAccount.of(model, (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)CohereCompletionRequest::buildDefaultUri));
        this.input = Objects.requireNonNull(input);
        this.modelId = model.getServiceSettings().modelId();
        this.inferenceEntityId = model.getInferenceEntityId();
        this.stream = stream;
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.account.uri());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new CohereCompletionRequestEntity(this.input, this.modelId, this.isStreaming())).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        CohereCompletionRequest.decorateWithAuthHeader(httpPost, this.account);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public String getInferenceEntityId() {
        return this.inferenceEntityId;
    }

    @Override
    public boolean isStreaming() {
        return this.stream;
    }

    @Override
    public URI getURI() {
        return this.account.uri();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }

    public static URI buildDefaultUri() throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("api.cohere.ai").setPathSegments(new String[]{"v1", "chat"}).build();
    }
}

