/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.jinaai;

import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.BaseResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.jinaai.JinaAIErrorResponseEntity;

public class JinaAIResponseHandler
extends BaseResponseHandler {
    static final String VALIDATION_ERROR_MESSAGE = "Received an input validation error response";
    static final String PAYMENT_ERROR_MESSAGE = "Payment required";

    public JinaAIResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, JinaAIErrorResponseEntity::fromResponse);
    }

    @Override
    protected void checkForFailureStatusCode(Request request, HttpResult result) throws RetryException {
        if (result.isSuccessfulResponse()) {
            return;
        }
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode == 500) {
            throw new RetryException(true, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode > 500) {
            throw new RetryException(false, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 429) {
            throw new RetryException(true, this.buildError("Received a rate limit status code", request, result));
        }
        if (statusCode == 400 || statusCode == 422) {
            throw new RetryException(false, this.buildError(VALIDATION_ERROR_MESSAGE, request, result));
        }
        if (statusCode == 401) {
            throw new RetryException(false, this.buildError("Received an authentication error status code", request, result));
        }
        if (statusCode == 402) {
            throw new RetryException(false, this.buildError(PAYMENT_ERROR_MESSAGE, request, result));
        }
        if (statusCode >= 300 && statusCode < 400) {
            throw new RetryException(false, this.buildError("Unhandled redirection", request, result));
        }
        throw new RetryException(false, this.buildError("Received an unsuccessful status code", request, result));
    }
}

