/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http;

import java.io.ByteArrayOutputStream;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpResponse;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.external.http.HttpResult;

public record StreamingHttpResult(HttpResponse response, Flow.Publisher<byte[]> body) {
    public boolean isSuccessfulResponse() {
        return RestStatus.isSuccessful((int)this.response.getStatusLine().getStatusCode());
    }

    public Flow.Publisher<HttpResult> toHttpResult() {
        return subscriber -> this.body().subscribe(new Flow.Subscriber<byte[]>(){

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscriber.onSubscribe(subscription);
            }

            @Override
            public void onNext(byte[] item) {
                subscriber.onNext(new HttpResult(StreamingHttpResult.this.response(), item));
            }

            @Override
            public void onError(Throwable throwable) {
                subscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                subscriber.onComplete();
            }
        });
    }

    public void readFullResponse(final ActionListener<HttpResult> fullResponse) {
        final ByteArrayOutputStream stream = new ByteArrayOutputStream();
        final AtomicReference<Object> upstream = new AtomicReference<Object>(null);
        this.body.subscribe(new Flow.Subscriber<byte[]>(){

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                upstream.set(subscription);
                ((Flow.Subscription)upstream.get()).request(1L);
            }

            @Override
            public void onNext(byte[] item) {
                stream.writeBytes(item);
                ((Flow.Subscription)upstream.get()).request(1L);
            }

            @Override
            public void onError(Throwable throwable) {
                ExceptionsHelper.maybeError((Throwable)throwable).ifPresent(ExceptionsHelper::maybeDieOnAnotherThread);
                fullResponse.onFailure((Exception)new RuntimeException("Fatal while fully consuming stream", throwable));
            }

            @Override
            public void onComplete() {
                fullResponse.onResponse((Object)new HttpResult(StreamingHttpResult.this.response, stream.toByteArray()));
            }
        });
    }
}

