/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.googleaistudio;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.StreamingChatCompletionResults;
import org.elasticsearch.xpack.inference.common.DelegatingProcessor;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEvent;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventField;

class GoogleAiStudioStreamingProcessor
extends DelegatingProcessor<Deque<ServerSentEvent>, StreamingChatCompletionResults.Results> {
    private static final Logger log = LogManager.getLogger(GoogleAiStudioStreamingProcessor.class);
    private final CheckedFunction<XContentParser, String, IOException> content;

    GoogleAiStudioStreamingProcessor(CheckedFunction<XContentParser, String, IOException> content) {
        this.content = content;
    }

    @Override
    protected void next(Deque<ServerSentEvent> item) throws Exception {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        ArrayDeque<StreamingChatCompletionResults.Result> results = new ArrayDeque<StreamingChatCompletionResults.Result>(item.size());
        for (ServerSentEvent event : item) {
            if (ServerSentEventField.DATA != event.name() || !event.hasValue()) continue;
            try {
                XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, event.value());
                try {
                    String delta = (String)this.content.apply((Object)jsonParser);
                    results.offer(new StreamingChatCompletionResults.Result(delta));
                }
                finally {
                    if (jsonParser == null) continue;
                    jsonParser.close();
                }
            }
            catch (Exception e) {
                log.warn("Failed to parse event from inference provider: {}", (Object)event);
                throw e;
            }
        }
        if (results.isEmpty()) {
            this.upstream().request(1L);
        } else {
            this.downstream().onNext(new StreamingChatCompletionResults.Results(results));
        }
    }
}

