/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.cohere;

import java.util.concurrent.Flow;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.core.inference.results.StreamingChatCompletionResults;
import org.elasticsearch.xpack.inference.external.cohere.CohereStreamingProcessor;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.BaseResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.cohere.CohereErrorResponseEntity;
import org.elasticsearch.xpack.inference.external.response.streaming.NewlineDelimitedByteProcessor;

public class CohereResponseHandler
extends BaseResponseHandler {
    static final String TEXTS_ARRAY_TOO_LARGE_MESSAGE_MATCHER = "invalid request: total number of texts must be at most";
    static final String TEXTS_ARRAY_ERROR_MESSAGE = "Received a texts array too large response";
    private final boolean canHandleStreamingResponse;

    public CohereResponseHandler(String requestType, ResponseParser parseFunction, boolean canHandleStreamingResponse) {
        super(requestType, parseFunction, CohereErrorResponseEntity::fromResponse);
        this.canHandleStreamingResponse = canHandleStreamingResponse;
    }

    @Override
    public boolean canHandleStreamingResponses() {
        return this.canHandleStreamingResponse;
    }

    @Override
    public InferenceServiceResults parseResult(Request request, Flow.Publisher<HttpResult> flow) {
        NewlineDelimitedByteProcessor ndProcessor = new NewlineDelimitedByteProcessor();
        CohereStreamingProcessor cohereProcessor = new CohereStreamingProcessor();
        flow.subscribe(ndProcessor);
        ndProcessor.subscribe(cohereProcessor);
        return new StreamingChatCompletionResults((Flow.Publisher)cohereProcessor);
    }

    @Override
    protected void checkForFailureStatusCode(Request request, HttpResult result) throws RetryException {
        if (result.isSuccessfulResponse()) {
            return;
        }
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode == 500) {
            throw new RetryException(true, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode > 500) {
            throw new RetryException(false, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 429) {
            throw new RetryException(true, this.buildError("Received a rate limit status code", request, result));
        }
        if (CohereResponseHandler.isTextsArrayTooLarge(result)) {
            throw new RetryException(false, this.buildError(TEXTS_ARRAY_ERROR_MESSAGE, request, result));
        }
        if (statusCode == 401) {
            throw new RetryException(false, this.buildError("Received an authentication error status code", request, result));
        }
        if (statusCode >= 300 && statusCode < 400) {
            throw new RetryException(false, this.buildError("Unhandled redirection", request, result));
        }
        throw new RetryException(false, this.buildError("Received an unsuccessful status code", request, result));
    }

    private static boolean isTextsArrayTooLarge(HttpResult result) {
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode == 400) {
            ErrorResponse errorEntity = CohereErrorResponseEntity.fromResponse(result);
            return errorEntity != null && errorEntity.getErrorMessage().contains(TEXTS_ARRAY_TOO_LARGE_MESSAGE_MATCHER);
        }
        return false;
    }
}

