/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.amazonbedrock;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockBaseClient;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockClientCache;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.AmazonBedrockRequest;
import org.elasticsearch.xpack.inference.external.response.amazonbedrock.AmazonBedrockResponseHandler;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockModel;

public abstract class AmazonBedrockExecutor
implements Runnable {
    protected final AmazonBedrockModel baseModel;
    protected final AmazonBedrockResponseHandler responseHandler;
    protected final Logger logger;
    protected final AmazonBedrockRequest request;
    protected final Supplier<Boolean> hasRequestCompletedFunction;
    protected final ActionListener<InferenceServiceResults> inferenceResultsListener;
    protected final AmazonBedrockClientCache clientCache;

    protected AmazonBedrockExecutor(AmazonBedrockRequest request, AmazonBedrockResponseHandler responseHandler, Logger logger, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> inferenceResultsListener, AmazonBedrockClientCache clientCache) {
        this.request = Objects.requireNonNull(request);
        this.responseHandler = Objects.requireNonNull(responseHandler);
        this.logger = Objects.requireNonNull(logger);
        this.hasRequestCompletedFunction = Objects.requireNonNull(hasRequestCompletedFunction);
        this.inferenceResultsListener = Objects.requireNonNull(inferenceResultsListener);
        this.clientCache = Objects.requireNonNull(clientCache);
        this.baseModel = request.model();
    }

    @Override
    public void run() {
        if (this.hasRequestCompletedFunction.get().booleanValue()) {
            return;
        }
        String inferenceEntityId = this.baseModel.getInferenceEntityId();
        try {
            AmazonBedrockBaseClient awsBedrockClient = this.clientCache.getOrCreateClient(this.baseModel, this.request.timeout());
            this.executeClientRequest(awsBedrockClient);
        }
        catch (Exception e) {
            String errorMessage = Strings.format((String)"Failed to send request from inference entity id [%s]", (Object[])new Object[]{inferenceEntityId});
            this.logger.warn(errorMessage, (Throwable)e);
            this.inferenceResultsListener.onFailure((Exception)((Object)new ElasticsearchException(errorMessage, (Throwable)e, new Object[0])));
        }
    }

    protected abstract void executeClientRequest(AmazonBedrockBaseClient var1);
}

