/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.List;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.transform.TransformMetadata;
import org.elasticsearch.xpack.core.transform.action.UpdateTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.AuthorizationState;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfigUpdate;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.TransformExtensionHolder;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.action.TransformConfigLinter;
import org.elasticsearch.xpack.transform.action.TransformUpdater;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.AuthorizationStatePersistenceUtils;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.transforms.Function;
import org.elasticsearch.xpack.transform.transforms.FunctionFactory;
import org.elasticsearch.xpack.transform.transforms.TransformTask;
import org.elasticsearch.xpack.transform.utils.SecondaryAuthorizationUtils;

public class TransportUpdateTransformAction
extends TransportTasksAction<TransformTask, UpdateTransformAction.Request, UpdateTransformAction.Response, UpdateTransformAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportUpdateTransformAction.class);
    private final Settings settings;
    private final Client client;
    private final TransformConfigManager transformConfigManager;
    private final SecurityContext securityContext;
    private final TransformAuditor auditor;
    private final ThreadPool threadPool;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Settings destIndexSettings;

    @Inject
    public TransportUpdateTransformAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, TransformServices transformServices, Client client, TransformExtensionHolder transformExtensionHolder) {
        super("cluster:admin/transform/update", clusterService, transportService, actionFilters, UpdateTransformAction.Request::new, UpdateTransformAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.settings = settings;
        this.client = client;
        this.transformConfigManager = transformServices.configManager();
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.auditor = transformServices.auditor();
        this.threadPool = threadPool;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.destIndexSettings = transformExtensionHolder.getTransformExtension().getTransformDestinationIndexSettings();
    }

    protected void doExecute(Task task, UpdateTransformAction.Request request, ActionListener<UpdateTransformAction.Response> listener) {
        ClusterState clusterState = this.clusterService.state();
        XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)clusterState);
        if (TransformMetadata.upgradeMode((ClusterState)clusterState)) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Cannot update any Transform while the Transform feature is upgrading.", RestStatus.CONFLICT, new Object[0]));
            return;
        }
        DiscoveryNodes nodes = clusterState.nodes();
        if (!nodes.isLocalNodeElectedMaster()) {
            if (nodes.getMasterNode() == null) {
                listener.onFailure((Exception)new MasterNotDiscoveredException());
            } else {
                this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, UpdateTransformAction.Response::new, TransportResponseHandler.TRANSPORT_WORKER));
            }
            return;
        }
        TransformConfigUpdate update = request.getUpdate();
        update.setHeaders(SecondaryAuthorizationUtils.getSecurityHeadersPreferringSecondary(this.threadPool, this.securityContext, clusterState));
        this.transformConfigManager.getTransformConfigurationForUpdate(request.getId(), (ActionListener<Tuple<TransformConfig, SeqNoPrimaryTermAndIndex>>)ActionListener.wrap(configAndVersion -> TransformUpdater.updateTransform(this.securityContext, this.indexNameExpressionResolver, clusterState, this.settings, this.client, this.transformConfigManager, this.auditor, (TransformConfig)configAndVersion.v1(), update, (SeqNoPrimaryTermAndIndex)configAndVersion.v2(), request.isDeferValidation(), false, true, request.getTimeout(), this.destIndexSettings, (ActionListener<TransformUpdater.UpdateResult>)ActionListener.wrap(updateResult -> {
            TransformConfig originalConfig = (TransformConfig)configAndVersion.v1();
            TransformConfig updatedConfig = updateResult.getConfig();
            AuthorizationState authState = updateResult.getAuthState();
            this.auditor.info(updatedConfig.getId(), "Updated transform.");
            logger.info("[{}] Updated transform [{}]", (Object)updatedConfig.getId(), (Object)updateResult.getStatus());
            this.checkTransformConfigAndLogWarnings(updatedConfig);
            boolean updateChangesSettings = update.changesSettings(originalConfig);
            boolean updateChangesHeaders = update.changesHeaders(originalConfig);
            boolean updateChangesDestIndex = update.changesDestIndex(originalConfig);
            if (updateChangesSettings || updateChangesHeaders || updateChangesDestIndex) {
                PersistentTasksCustomMetadata.PersistentTask<?> transformTask = TransformTask.getTransformTask(request.getId(), clusterState);
                if (transformTask != null && transformTask.isAssigned() && transformTask.getState() instanceof TransformState && ((TransformState)transformTask.getState()).getTaskState() != TransformTaskState.FAILED) {
                    ActionListener taskUpdateListener = ActionListener.wrap(arg_0 -> ((ActionListener)listener).onResponse(arg_0), e -> {
                        if (e instanceof TransformTaskDisappearedDuringUpdateException) {
                            logger.debug("[{}] transform task disappeared during update, ignoring", (Object)request.getId());
                            listener.onResponse((Object)new UpdateTransformAction.Response(updatedConfig));
                            return;
                        }
                        if (e instanceof TransformTaskUpdateException) {
                            logger.warn(() -> Strings.format((String)"[%s] failed to notify running transform task about update. New settings will be applied after next checkpoint.", (Object[])new Object[]{request.getId()}), (Throwable)e);
                            listener.onResponse((Object)new UpdateTransformAction.Response(updatedConfig));
                            return;
                        }
                        listener.onFailure(e);
                    });
                    request.setNodes(new String[]{transformTask.getExecutorNode()});
                    request.setConfig(updatedConfig);
                    request.setAuthState(authState);
                    super.doExecute(task, (BaseTasksRequest)request, taskUpdateListener);
                    return;
                }
                if (updateChangesHeaders) {
                    AuthorizationStatePersistenceUtils.persistAuthState(this.settings, this.transformConfigManager, updatedConfig.getId(), authState, (ActionListener<Void>)ActionListener.wrap(aVoid -> listener.onResponse((Object)new UpdateTransformAction.Response(updatedConfig)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                } else {
                    listener.onResponse((Object)new UpdateTransformAction.Response(updatedConfig));
                }
            } else {
                listener.onResponse((Object)new UpdateTransformAction.Response(updatedConfig));
            }
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    private void checkTransformConfigAndLogWarnings(TransformConfig config) {
        Function function = FunctionFactory.create(config);
        List<String> warnings = TransformConfigLinter.getWarnings(function, config.getSource(), config.getSyncConfig());
        for (String warning : warnings) {
            logger.warn(() -> Strings.format((String)"[%s] %s", (Object[])new Object[]{config.getId(), warning}));
            this.auditor.warning(config.getId(), warning);
        }
    }

    protected void taskOperation(CancellableTask actionTask, UpdateTransformAction.Request request, TransformTask transformTask, ActionListener<UpdateTransformAction.Response> listener) {
        transformTask.applyNewSettings(request.getConfig().getSettings());
        transformTask.applyNewAuthState(request.getAuthState());
        transformTask.checkAndResetDestinationIndexBlock(request.getConfig());
        listener.onResponse((Object)new UpdateTransformAction.Response(request.getConfig()));
    }

    protected UpdateTransformAction.Response newResponse(UpdateTransformAction.Request request, List<UpdateTransformAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (tasks.isEmpty()) {
            if (!taskOperationFailures.isEmpty()) {
                throw new TransformTaskUpdateException("Failed to update running transform task.", taskOperationFailures.get(0).getCause(), new Object[0]);
            }
            if (!failedNodeExceptions.isEmpty()) {
                throw new TransformTaskUpdateException("Failed to update running transform task.", (Throwable)failedNodeExceptions.get(0), new Object[0]);
            }
            throw new TransformTaskDisappearedDuringUpdateException("Could not update running transform as it has been stopped.");
        }
        return tasks.get(0);
    }

    private static class TransformTaskUpdateException
    extends ElasticsearchException {
        TransformTaskUpdateException(String msg, Throwable cause, Object ... args) {
            super(msg, cause, args);
        }
    }

    private static class TransformTaskDisappearedDuringUpdateException
    extends ElasticsearchException {
        TransformTaskDisappearedDuringUpdateException(String msg) {
            super(msg, new Object[0]);
        }
    }
}

