/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceFieldConfig;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.EclatMapReducer;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.FrequentItemSetsAggregationBuilder;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.HashBasedTransactionStore;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.ImmutableTransactionStore;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.AbstractItemSetMapReducer;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.InternalItemSetMapReduceAggregation;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.ItemSetMapReduceAggregator;

public class FrequentItemSetsAggregatorFactory
extends AggregatorFactory {
    private final List<MultiValuesSourceFieldConfig> fields;
    private final double minimumSupport;
    private final int minimumSetSize;
    private final int size;
    private final QueryBuilder documentFilter;
    private final String executionHint;

    public static Writeable.Reader<InternalItemSetMapReduceAggregation<?, ?, ?, ?>> getResultReader() {
        return in -> new InternalItemSetMapReduceAggregation(in, mapReducerReader -> {
            String mapReducerName = in.readString();
            if ("frequent_items-eclat-1".equals(mapReducerName)) {
                return new EclatMapReducer("frequent_item_sets", in);
            }
            throw new AggregationExecutionException("Unknown map reducer [" + mapReducerName + "]");
        });
    }

    public FrequentItemSetsAggregatorFactory(String name, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, List<MultiValuesSourceFieldConfig> fields, double minimumSupport, int minimumSetSize, int size, QueryBuilder documentFilter, String executionHint) throws IOException {
        super(name, context, parent, subFactoriesBuilder, metadata);
        this.fields = fields;
        this.minimumSupport = minimumSupport;
        this.minimumSetSize = minimumSetSize;
        this.size = size;
        this.documentFilter = documentFilter;
        this.executionHint = executionHint;
    }

    protected Aggregator createInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        ArrayList<Tuple> configsAndFilters = new ArrayList<Tuple>(this.fields.size());
        for (MultiValuesSourceFieldConfig field : this.fields) {
            configsAndFilters.add(Tuple.tuple((Object)ValuesSourceConfig.resolve((AggregationContext)this.context, (ValueType)field.getUserValueTypeHint(), (String)field.getFieldName(), (Script)field.getScript(), (Object)field.getMissing(), (ZoneId)field.getTimeZone(), (String)field.getFormat(), (ValuesSourceType)CoreValuesSourceType.KEYWORD), (Object)field.getIncludeExclude()));
        }
        EclatMapReducer eclatMapReducer = new EclatMapReducer("frequent_item_sets", this.minimumSupport, this.minimumSetSize, this.size, this.context.profiling());
        AbstractItemSetMapReducer.OrdinalOptimization ordinalOptimization = eclatMapReducer.getDefaultOrdinalOptimization();
        if ("map".equals(this.executionHint)) {
            ordinalOptimization = AbstractItemSetMapReducer.OrdinalOptimization.NO_ORDINALS;
        }
        return new ItemSetMapReduceAggregator<HashBasedTransactionStore, ImmutableTransactionStore, HashBasedTransactionStore, EclatMapReducer.EclatResult>(this, this.name, FrequentItemSetsAggregationBuilder.REGISTRY_KEY, this.context, parent, metadata, (AbstractItemSetMapReducer)eclatMapReducer, configsAndFilters, this.documentFilter, ordinalOptimization){};
    }
}

