/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.common.io.stream.BytesRefStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.CountingItemSetTraverser;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.FrequentItemSetCollector;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.HashBasedTransactionStore;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.ImmutableTransactionStore;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.TransactionStore;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.AbstractItemSetMapReducer;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.ItemSetMapReduceValueSource;

public final class EclatMapReducer
extends AbstractItemSetMapReducer<HashBasedTransactionStore, ImmutableTransactionStore, HashBasedTransactionStore, EclatResult> {
    private static final int ITERATION_CHECK_INTERVAL = 100000;
    private static final Logger logger = LogManager.getLogger(EclatMapReducer.class);
    private static final int VERSION = 1;
    public static final String NAME = "frequent_items-eclat-1";
    private static final int MAX_BITSET_CACHE_NUMBER_OF_TRANSACTIONS = 65536;
    private static final int BITSET_CACHE_TRAVERSAL_DEPTH = 60;
    private final double minimumSupport;
    private final int minimumSetSize;
    private final int size;
    private final boolean profiling;
    private final Map<String, Object> profilingInfoReduce;
    private final Map<String, Object> profilingInfoMap;

    @Override
    protected AbstractItemSetMapReducer.OrdinalOptimization getDefaultOrdinalOptimization() {
        return AbstractItemSetMapReducer.OrdinalOptimization.GLOBAL_ORDINALS;
    }

    public EclatMapReducer(String aggregationName, double minimumSupport, int minimumSetSize, int size, boolean profiling) {
        super(aggregationName, NAME);
        assert (size > 0);
        assert (minimumSetSize > 0);
        this.minimumSupport = minimumSupport;
        this.minimumSetSize = minimumSetSize;
        this.size = size;
        this.profiling = profiling;
        this.profilingInfoReduce = profiling ? new LinkedHashMap() : null;
        this.profilingInfoMap = profiling ? new LinkedHashMap() : null;
    }

    public EclatMapReducer(String aggregationName, StreamInput in) throws IOException {
        super(aggregationName, NAME);
        this.minimumSupport = in.readDouble();
        this.minimumSetSize = in.readVInt();
        this.size = in.readVInt();
        this.profiling = in.readBoolean();
        this.profilingInfoReduce = this.profiling ? new LinkedHashMap() : null;
        this.profilingInfoMap = this.profiling ? new LinkedHashMap() : null;
    }

    public double getMinimumSupport() {
        return this.minimumSupport;
    }

    public int getMinimumSetSize() {
        return this.minimumSetSize;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeDouble(this.minimumSupport);
        out.writeVInt(this.minimumSetSize);
        out.writeVInt(this.size);
        out.writeBoolean(this.profiling);
    }

    @Override
    public HashBasedTransactionStore mapInit(BigArrays bigArrays) {
        return new HashBasedTransactionStore(bigArrays);
    }

    @Override
    public HashBasedTransactionStore map(Stream<Tuple<ItemSetMapReduceValueSource.Field, List<Object>>> keyValues, HashBasedTransactionStore transactionStore) {
        transactionStore.add(keyValues);
        return transactionStore;
    }

    @Override
    public HashBasedTransactionStore mapFiltered(HashBasedTransactionStore transactionStore) {
        transactionStore.addFilteredTransaction();
        return transactionStore;
    }

    @Override
    protected ImmutableTransactionStore mapFinalize(HashBasedTransactionStore transactionStore, List<AbstractItemSetMapReducer.OrdinalLookupFunction> ordinalLookup) throws IOException {
        long relativeStartNanos = System.nanoTime();
        if (this.profiling) {
            this.profilingInfoMap.put("ram_bytes_transactionstore_after_map", transactionStore.ramBytesUsed());
            this.profilingInfoMap.put("total_items_after_map", transactionStore.getTotalItemCount());
            this.profilingInfoMap.put("total_transactions_after_map", transactionStore.getTotalTransactionCount());
            this.profilingInfoMap.put("filtered_transactions_after_map", transactionStore.getFilteredTransactionCount());
            this.profilingInfoMap.put("unique_items_after_map", transactionStore.getUniqueItemsCount());
            this.profilingInfoMap.put("unique_transactions_after_map", transactionStore.getUniqueTransactionCount());
        }
        ImmutableTransactionStore transactionStoreMapFinalize = EclatMapReducer.rewriteOrdinalItems(transactionStore.createImmutableTransactionStore(), ordinalLookup);
        if (this.profiling) {
            this.profilingInfoMap.put("ram_bytes_transactionstore_map_finalize", transactionStoreMapFinalize.ramBytesUsed());
            this.profilingInfoMap.put("runtime_ms_finalize_map", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - relativeStartNanos));
        }
        return transactionStoreMapFinalize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImmutableTransactionStore rewriteOrdinalItems(ImmutableTransactionStore transactionStore, List<AbstractItemSetMapReducer.OrdinalLookupFunction> ordinalLookups) throws IOException {
        ImmutableTransactionStore immutableTransactionStore;
        if (ordinalLookups == null || ordinalLookups.isEmpty()) {
            return transactionStore;
        }
        logger.trace("rewrite items based on ordinals");
        BytesRef scratchBytesRef = new BytesRef();
        ByteArrayStreamInput scratchByteArrayStreamInput = new ByteArrayStreamInput();
        BytesRefStreamOutput scratchItemBytesStreamOutput = new BytesRefStreamOutput();
        BytesRefArray items = transactionStore.getItems();
        BytesRefArray rewrittenItems = null;
        try {
            rewrittenItems = new BytesRefArray(items.size(), transactionStore.getBigArrays());
            for (long i = 0L; i < items.size(); ++i) {
                items.get(i, scratchBytesRef);
                scratchByteArrayStreamInput.reset(scratchBytesRef.bytes, scratchBytesRef.offset, scratchBytesRef.length);
                int fieldId = scratchByteArrayStreamInput.readVInt();
                Object ordinal = scratchByteArrayStreamInput.readGenericValue();
                scratchItemBytesStreamOutput.reset();
                scratchItemBytesStreamOutput.writeVInt(fieldId);
                scratchItemBytesStreamOutput.writeGenericValue(ordinalLookups.get(fieldId).apply(ordinal));
                rewrittenItems.append(scratchItemBytesStreamOutput.get());
            }
            ImmutableTransactionStore rewrittenStore = new ImmutableTransactionStore(transactionStore.getBigArrays(), rewrittenItems, transactionStore.getItemCounts(), transactionStore.getTotalItemCount(), transactionStore.getTransactions(), transactionStore.getTransactionCounts(), transactionStore.getTotalTransactionCount(), transactionStore.getFilteredTransactionCount());
            rewrittenItems = items;
            immutableTransactionStore = rewrittenStore;
        }
        catch (Throwable throwable) {
            Releasables.close(rewrittenItems);
            throw throwable;
        }
        Releasables.close((Releasable)rewrittenItems);
        return immutableTransactionStore;
    }

    @Override
    protected void collectDebugInfo(BiConsumer<String, Object> add) {
        this.profilingInfoMap.forEach(add);
    }

    @Override
    public ImmutableTransactionStore readMapReduceContext(StreamInput in, BigArrays bigArrays) throws IOException {
        return new ImmutableTransactionStore(in, bigArrays);
    }

    @Override
    protected ImmutableTransactionStore combine(Stream<ImmutableTransactionStore> partitions, HashBasedTransactionStore transactionStore, Supplier<Boolean> isCanceledSupplier) {
        HashBasedTransactionStore t = this.reduce(partitions, transactionStore, isCanceledSupplier);
        return t.createImmutableTransactionStore();
    }

    @Override
    public EclatResult readResult(StreamInput in, BigArrays bigArrays) throws IOException {
        return new EclatResult(in);
    }

    @Override
    public HashBasedTransactionStore reduceInit(BigArrays bigArrays) {
        return new HashBasedTransactionStore(bigArrays);
    }

    @Override
    public HashBasedTransactionStore reduce(Stream<ImmutableTransactionStore> partitions, HashBasedTransactionStore transactionStore, Supplier<Boolean> isCanceledSupplier) {
        AtomicLong ramBytesSum = new AtomicLong();
        partitions.forEachOrdered(p -> {
            try {
                if (((Boolean)isCanceledSupplier.get()).booleanValue()) {
                    throw new TaskCancelledException("Cancelled");
                }
                if (this.profiling) {
                    ramBytesSum.addAndGet(p.ramBytesUsed());
                }
                transactionStore.merge((TransactionStore)p);
            }
            catch (IOException e) {
                throw new AggregationExecutionException("Failed to merge shard results", (Throwable)e);
            }
            finally {
                Releasables.close((Releasable)p);
            }
        });
        if (this.profiling) {
            this.profilingInfoReduce.compute("max_ram_bytes_sum_transactionstore_before_merge", (k, v) -> v == null ? ramBytesSum.get() : Math.max(ramBytesSum.get(), (Long)v));
        }
        return transactionStore;
    }

    @Override
    public EclatResult reduceFinalize(HashBasedTransactionStore transactionStore, List<ItemSetMapReduceValueSource.Field> fields, Supplier<Boolean> isCanceledSupplier) throws IOException {
        if (this.profiling) {
            this.profilingInfoReduce.put("ram_bytes_transactionstore_after_reduce", transactionStore.ramBytesUsed());
            this.profilingInfoReduce.put("total_items_after_reduce", transactionStore.getTotalItemCount());
            this.profilingInfoReduce.put("total_transactions_after_reduce", transactionStore.getTotalTransactionCount());
            this.profilingInfoReduce.put("filtered_transactions_after_reduce", transactionStore.getFilteredTransactionCount());
            this.profilingInfoReduce.put("unique_items_after_reduce", transactionStore.getUniqueItemsCount());
            this.profilingInfoReduce.put("unique_transactions_after_reduce", transactionStore.getUniqueTransactionCount());
        }
        transactionStore.prune(this.minimumSupport);
        if (this.profiling) {
            this.profilingInfoReduce.put("ram_bytes_transactionstore_after_prune", transactionStore.ramBytesUsed());
            this.profilingInfoReduce.put("total_items_after_prune", transactionStore.getTotalItemCount());
            this.profilingInfoReduce.put("total_transactions_after_prune", transactionStore.getTotalTransactionCount());
            this.profilingInfoReduce.put("filtered_transactions_after_prune", transactionStore.getFilteredTransactionCount());
            this.profilingInfoReduce.put("unique_items_after_prune", transactionStore.getUniqueItemsCount());
            this.profilingInfoReduce.put("unique_transactions_after_prune", transactionStore.getUniqueTransactionCount());
        }
        if (isCanceledSupplier.get().booleanValue()) {
            throw new TaskCancelledException("Cancelled");
        }
        try (ImmutableTransactionStore immutableTransactionStore = transactionStore.createImmutableTransactionStore();){
            EclatResult frequentItemSets;
            transactionStore.close();
            EclatResult eclatResult = frequentItemSets = EclatMapReducer.eclat(immutableTransactionStore, this.minimumSupport, this.minimumSetSize, this.size, fields, isCanceledSupplier, this.profilingInfoReduce);
            return eclatResult;
        }
    }

    @Override
    public EclatResult finalizeSampling(SamplingContext samplingContext, EclatResult eclatResult) {
        for (FrequentItemSetCollector.FrequentItemSet itemSet : eclatResult.getFrequentItemSets()) {
            itemSet.setDocCount(samplingContext.scaleUp(itemSet.getDocCount()));
        }
        return eclatResult;
    }

    private static EclatResult eclat(TransactionStore transactionStore, double minimumSupport, int minimumSetSize, int size, List<ItemSetMapReduceValueSource.Field> fields, Supplier<Boolean> isCanceledSupplier, Map<String, Object> profilingInfoReduce) throws IOException {
        long relativeStartNanos = System.nanoTime();
        long totalTransactionCount = transactionStore.getTotalTransactionCount();
        LinkedHashMap<String, Object> profilingInfo = null;
        long minCount = (long)Math.ceil((double)totalTransactionCount * minimumSupport);
        if (profilingInfoReduce != null) {
            profilingInfo = new LinkedHashMap<String, Object>(profilingInfoReduce);
            profilingInfo.put("start_min_count_eclat", minCount);
        }
        try (TransactionStore.TopItemIds topItemIds = transactionStore.getTopItemIds();){
            CountingItemSetTraverser setTraverser = new CountingItemSetTraverser(transactionStore, topItemIds, 60, (int)Math.min(65536L, totalTransactionCount), minCount);
            try {
                logger.trace("total transaction count {}, min count: {}, total items: {}", (Object)totalTransactionCount, (Object)minCount, (Object)transactionStore.getTotalItemCount());
                FrequentItemSetCollector collector = new FrequentItemSetCollector(transactionStore, topItemIds, size, minCount);
                long numberOfSetsChecked = 0L;
                long previousMinCount = 0L;
                while (setTraverser.next(minCount)) {
                    if (numberOfSetsChecked % 100000L == 0L) {
                        logger.debug("checked {} sets", (Object)numberOfSetsChecked);
                        if (isCanceledSupplier.get().booleanValue()) {
                            long eclatRuntimeNanos = System.nanoTime() - relativeStartNanos;
                            logger.debug("eclat has been cancelled after {} iterations and a runtime of {}s", (Object)numberOfSetsChecked, (Object)TimeUnit.NANOSECONDS.toSeconds(eclatRuntimeNanos));
                            throw new TaskCancelledException("Cancelled");
                        }
                    }
                    ++numberOfSetsChecked;
                    if (setTraverser.getCount() < minCount) {
                        setTraverser.prune();
                        if (setTraverser.atLeaf() && !setTraverser.hasBeenVisited() && setTraverser.getCount() >= minCount && setTraverser.getItemSetBitSet().cardinality() >= minimumSetSize) {
                            logger.trace("add after prune");
                            minCount = collector.add(setTraverser.getItemSetBitSet(), setTraverser.getCount());
                        }
                        if (!setTraverser.atLeaf()) continue;
                        setTraverser.pruneToNextMainBranch();
                        continue;
                    }
                    if (!setTraverser.hasParentBeenVisited() && setTraverser.getItemSetBitSet().cardinality() > minimumSetSize && setTraverser.getCount() < setTraverser.getParentCount()) {
                        minCount = collector.add(setTraverser.getParentItemSetBitSet(), setTraverser.getParentCount());
                    }
                    setTraverser.setParentVisited();
                    if (setTraverser.atLeaf() && setTraverser.getItemSetBitSet().cardinality() >= minimumSetSize) {
                        minCount = collector.add(setTraverser.getItemSetBitSet(), setTraverser.getCount());
                    }
                    if (previousMinCount != minCount) {
                        previousMinCount = minCount;
                        logger.debug("adjusting min count to {}", (Object)minCount);
                    }
                    if (!setTraverser.atLeaf()) continue;
                    setTraverser.prune();
                    setTraverser.pruneToNextMainBranch();
                }
                FrequentItemSetCollector.FrequentItemSet[] topFrequentItems = collector.finalizeAndGetResults(fields);
                long eclatRuntimeNanos = System.nanoTime() - relativeStartNanos;
                if (profilingInfoReduce != null) {
                    profilingInfo.put("end_min_count_eclat", minCount);
                    profilingInfo.put("runtime_ms_eclat", TimeUnit.NANOSECONDS.toMillis(eclatRuntimeNanos));
                    profilingInfo.put("item_sets_checked_eclat", numberOfSetsChecked);
                }
                EclatResult eclatResult = new EclatResult(topFrequentItems, profilingInfo);
                setTraverser.close();
                return eclatResult;
            }
            catch (Throwable throwable) {
                try {
                    setTraverser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    static class EclatResult
    implements ToXContent,
    Writeable {
        private final FrequentItemSetCollector.FrequentItemSet[] frequentItemSets;
        private final Map<String, Object> profilingInfo;

        EclatResult(FrequentItemSetCollector.FrequentItemSet[] frequentItemSets, @Nullable Map<String, Object> profilingInfo) {
            this.frequentItemSets = frequentItemSets;
            this.profilingInfo = profilingInfo == null ? Collections.emptyMap() : profilingInfo;
        }

        EclatResult(StreamInput in) throws IOException {
            this.frequentItemSets = (FrequentItemSetCollector.FrequentItemSet[])in.readArray(FrequentItemSetCollector.FrequentItemSet::new, FrequentItemSetCollector.FrequentItemSet[]::new);
            this.profilingInfo = in.readOrderedMap(StreamInput::readString, StreamInput::readGenericValue);
        }

        FrequentItemSetCollector.FrequentItemSet[] getFrequentItemSets() {
            return this.frequentItemSets;
        }

        Map<String, Object> getProfilingInfo() {
            return this.profilingInfo;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeArray((Writeable[])this.frequentItemSets);
            out.writeMap(this.profilingInfo, StreamOutput::writeGenericValue);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(Aggregation.CommonFields.BUCKETS.getPreferredName(), (Object)this.frequentItemSets);
            if (params != null && params.paramAsBoolean("profile", false)) {
                builder.startObject("profile");
                builder.mapContents(this.profilingInfo);
                builder.endObject();
            }
            return builder;
        }
    }
}

