/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.CharArraySet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.TokenFilterFactory;

public abstract class AbstractCompoundWordTokenFilterFactory
extends AbstractTokenFilterFactory {
    protected final int minWordSize;
    protected final int minSubwordSize;
    protected final int maxSubwordSize;
    protected final boolean onlyLongestMatch;
    protected final CharArraySet wordList;

    protected AbstractCompoundWordTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(name);
        this.minWordSize = settings.getAsInt("min_word_size", Integer.valueOf(5));
        this.minSubwordSize = settings.getAsInt("min_subword_size", Integer.valueOf(2));
        this.maxSubwordSize = settings.getAsInt("max_subword_size", Integer.valueOf(15));
        this.onlyLongestMatch = settings.getAsBoolean("only_longest_match", Boolean.valueOf(false));
        this.wordList = Analysis.getWordSet((Environment)env, (Settings)settings, (String)"word_list");
        if (this.wordList == null) {
            throw new IllegalArgumentException("word_list must be provided for [" + name + "], either as a path to a file, or directly");
        }
    }

    public TokenFilterFactory getSynonymFilter() {
        return IDENTITY_FILTER;
    }
}

