/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.action.user.ChangePasswordRequestBuilder;
import org.elasticsearch.xpack.security.rest.action.user.NativeUserBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public class RestChangePasswordAction
extends NativeUserBaseRestHandler
implements RestRequestFilter {
    private final SecurityContext securityContext;
    private final Hasher passwordHasher;
    private static final Set<String> FILTERED_FIELDS = Set.of("password", "password_hash");

    public RestChangePasswordAction(Settings settings, SecurityContext securityContext, XPackLicenseState licenseState) {
        super(settings, licenseState);
        this.securityContext = securityContext;
        this.passwordHasher = Hasher.resolve((String)((String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(settings)));
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_security/user/{username}/_password"), new RestHandler.Route(RestRequest.Method.POST, "/_security/user/{username}/_password"), new RestHandler.Route(RestRequest.Method.PUT, "/_security/user/_password"), new RestHandler.Route(RestRequest.Method.POST, "/_security/user/_password"));
    }

    public String getName() {
        return "security_change_password_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        User user = this.securityContext.getUser();
        String username = request.param("username") == null ? user.principal() : request.param("username");
        String refresh = request.param("refresh");
        ReleasableBytesReference content = request.requiredContent();
        return arg_0 -> this.lambda$innerPrepareRequest$0(client, username, (BytesReference)content, request, refresh, arg_0);
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }

    private /* synthetic */ void lambda$innerPrepareRequest$0(NodeClient client, String username, BytesReference content, RestRequest request, String refresh, RestChannel channel) throws Exception {
        ((ChangePasswordRequestBuilder)new ChangePasswordRequestBuilder((ElasticsearchClient)client).username(username).source(content, request.getXContentType(), this.passwordHasher).setRefreshPolicy(refresh)).execute((ActionListener)new RestBuilderListener<ActionResponse.Empty>(this, channel){

            public RestResponse buildResponse(ActionResponse.Empty response, XContentBuilder builder) throws Exception {
                return new RestResponse(RestStatus.OK, builder.startObject().endObject());
            }
        });
    }
}

