/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.role;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.security.action.ActionTypes;
import org.elasticsearch.xpack.core.security.action.role.BulkDeleteRolesRequest;
import org.elasticsearch.xpack.security.rest.action.role.NativeRoleBaseRestHandler;

public class RestBulkDeleteRolesAction
extends NativeRoleBaseRestHandler {
    private static final ConstructingObjectParser<BulkDeleteRolesRequest, Void> PARSER = new ConstructingObjectParser("bulk_delete_roles_request", a -> new BulkDeleteRolesRequest((List)a[0]));

    public RestBulkDeleteRolesAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "/_security/role"));
    }

    public String getName() {
        return "security_bulk_delete_roles_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        BulkDeleteRolesRequest bulkDeleteRolesRequest = (BulkDeleteRolesRequest)PARSER.parse(request.contentParser(), null);
        if (request.param("refresh") != null) {
            bulkDeleteRolesRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.parse((String)request.param("refresh")));
        }
        return channel -> client.execute(ActionTypes.BULK_DELETE_ROLES, (ActionRequest)bulkDeleteRolesRequest, (ActionListener)new RestToXContentListener(channel));
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("names", new String[0]));
    }
}

