/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.pki;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.ssl.CertParsingUtils;

public class X509AuthenticationToken
implements AuthenticationToken {
    private final String dn;
    private final X509Certificate[] credentials;
    private final Authentication delegateeAuthentication;
    private String principal;

    public X509AuthenticationToken(X509Certificate[] certificates) {
        this(certificates, null);
    }

    private X509AuthenticationToken(X509Certificate[] certificates, Authentication delegateeAuthentication) {
        this.credentials = Objects.requireNonNull(certificates);
        if (!CertParsingUtils.isOrderedCertificateChain(Arrays.asList(certificates))) {
            throw new IllegalArgumentException("certificates chain array is not ordered");
        }
        this.principal = this.dn = certificates.length == 0 ? "" : certificates[0].getSubjectX500Principal().toString();
        this.delegateeAuthentication = delegateeAuthentication;
    }

    public static X509AuthenticationToken delegated(X509Certificate[] certificates, Authentication delegateeAuthentication) {
        Objects.requireNonNull(delegateeAuthentication);
        return new X509AuthenticationToken(certificates, delegateeAuthentication);
    }

    public String principal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public X509Certificate[] credentials() {
        return this.credentials;
    }

    public String dn() {
        return this.dn;
    }

    public void clearCredentials() {
    }

    public boolean isDelegated() {
        return this.delegateeAuthentication != null;
    }

    public Authentication getDelegateeAuthentication() {
        return this.delegateeAuthentication;
    }
}

