/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchbusinessrules;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.xpack.searchbusinessrules.CappedScorer;

public abstract class CappedScoreWeight
extends Weight {
    private final float maxScore;
    private final Weight innerWeight;

    protected CappedScoreWeight(Query query, Weight innerWeight, float maxScore) {
        super(query);
        this.maxScore = maxScore;
        this.innerWeight = innerWeight;
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return this.innerWeight.isCacheable(ctx);
    }

    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        final ScorerSupplier innerScorerSupplier = this.innerWeight.scorerSupplier(context);
        if (innerScorerSupplier == null) {
            return null;
        }
        return new ScorerSupplier(){

            public Scorer get(long leadCost) throws IOException {
                return new CappedScorer(innerScorerSupplier.get(leadCost), CappedScoreWeight.this.maxScore);
            }

            public long cost() {
                return innerScorerSupplier.cost();
            }
        };
    }

    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        Scorer s = this.scorer(context);
        if (s == null) {
            boolean exists = false;
        } else {
            TwoPhaseIterator twoPhase = s.twoPhaseIterator();
            if (twoPhase == null) {
                boolean exists = s.iterator().advance(doc) == doc;
            } else {
                boolean exists = twoPhase.approximation().advance(doc) == doc && twoPhase.matches();
            }
        }
        Explanation sub = this.innerWeight.explain(context, doc);
        if (sub.isMatch() && sub.getValue().floatValue() > this.maxScore) {
            return Explanation.match((Number)Float.valueOf(this.maxScore), (String)("Capped score of " + String.valueOf(this.innerWeight.getQuery()) + ", max of"), (Explanation[])new Explanation[]{sub, Explanation.match((Number)Float.valueOf(this.maxScore), (String)"maximum score", (Explanation[])new Explanation[0])});
        }
        return sub;
    }
}

