/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.aggregatemetric.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.Min;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.aggregatemetric.aggregations.support.AggregateMetricsValuesSource;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateMetricDoubleFieldMapper;

class AggregateMetricBackedMinAggregator
extends NumericMetricsAggregator.SingleValue {
    private final AggregateMetricsValuesSource.AggregateMetricDouble valuesSource;
    final DocValueFormat format;
    DoubleArray mins;

    AggregateMetricBackedMinAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (config.hasValues());
        this.valuesSource = (AggregateMetricsValuesSource.AggregateMetricDouble)config.getValuesSource();
        this.mins = context.bigArrays().newDoubleArray(1L, false);
        this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
        this.format = config.format();
    }

    public ScoreMode scoreMode() {
        return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final BigArrays bigArrays = this.bigArrays();
        SortedNumericDoubleValues allValues = this.valuesSource.getAggregateMetricValues(aggCtx.getLeafReaderContext(), AggregateMetricDoubleFieldMapper.Metric.min);
        final NumericDoubleValues values = MultiValueMode.MIN.select(allValues);
        return new LeafBucketCollectorBase(sub, allValues){

            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= AggregateMetricBackedMinAggregator.this.mins.size()) {
                    long from = AggregateMetricBackedMinAggregator.this.mins.size();
                    AggregateMetricBackedMinAggregator.this.mins = bigArrays.grow(AggregateMetricBackedMinAggregator.this.mins, bucket + 1L);
                    AggregateMetricBackedMinAggregator.this.mins.fill(from, AggregateMetricBackedMinAggregator.this.mins.size(), Double.POSITIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    double value = values.doubleValue();
                    double min = AggregateMetricBackedMinAggregator.this.mins.get(bucket);
                    min = Math.min(min, value);
                    AggregateMetricBackedMinAggregator.this.mins.set(bucket, min);
                }
            }
        };
    }

    public double metric(long owningBucketOrd) {
        if (owningBucketOrd >= this.mins.size()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.mins.get(owningBucketOrd);
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.mins.size()) {
            return this.buildEmptyAggregation();
        }
        return new Min(this.name, this.mins.get(bucket), this.format, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return Min.createEmptyMin((String)this.name, (DocValueFormat)this.format, (Map)this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable)this.mins);
    }
}

